
import time
import urllib.request
import urllib.parse
import urllib.error
import urllib.parse

from cryptography.fernet import Fernet
from django.conf import settings
from django.utils.encoding import smart_text

from wiki.utils.crypto_helpers import generate_fernet_key

salt = b'\x9a\xc9\x0b\xbc)XP\x03R\xf0\xc5\xcc\xbaT\xd1\x19'
KEY_STRING = generate_fernet_key(settings.QR_SECRET_STR, salt)


def generate_qr_url(tag, user):
    data_for_encryption = '{uid};{time}'.format(uid=user.staff.uid, time=int(time.time()))

    secret_request_param = _encrypt_string(data_for_encryption)
    page_url_with_data = _generate_page_url(tag, secret_request_param)

    qr_url = '{gen_url}/?{qr_get_params}'.format(
        gen_url=settings.QR_GENERATOR_URL.rstrip('/'),
        qr_get_params=urllib.parse.urlencode({'text': page_url_with_data}),
    )
    return qr_url


def fetch_data_from_qr_url(qr_url):
    qr_url_query = urllib.parse.urlparse(qr_url).query
    page_url = urllib.parse.parse_qs(qr_url_query)['text'][0]
    page_url_query = urllib.parse.urlparse(page_url).query
    crypted_data = urllib.parse.unquote(urllib.parse.unquote(page_url_query))
    decrypted = _decrypt_string(crypted_data).decode('utf-8')
    uid, timestamp = decrypted.split(';', 1)
    return page_url, uid, timestamp


def _encrypt_string(string_):
    f = Fernet(KEY_STRING)
    return f.encrypt(string_.encode())


def _decrypt_string(string_):
    f = Fernet(KEY_STRING)
    return f.decrypt(string_.encode())


def _generate_page_url(tag, secret_request_param):
    scheme = settings.WIKI_PROTOCOL
    netloc = settings.NGINX_HOST
    url = smart_text(tag)
    query = urllib.parse.quote(secret_request_param)
    fragment = None
    return urllib.parse.urlunsplit((scheme, netloc, url, query, fragment))
