from django.http import HttpResponse
from functools import wraps

from wiki.utils.leaky_bucket import LeakyBucket


def is_user_request_path(request):
    return request.path.startswith('/_api/frontend') or request.path.startswith('/_api/v1')


def ratelimiter(rate=10):
    def _ratelimiter(f):
        @wraps(f)
        def wrapper(*args, **kwargs):
            bucket_key = f'{f.__module__}:{f.__name__}'
            bucket = LeakyBucket(key=bucket_key, rate=rate)
            if not bucket.consume():
                return HttpResponse(status=429)
            return f(*args, **kwargs)
        return wrapper

    return _ratelimiter
