import requests
from django.conf import settings
from django_tools_log_context.provider.request import _get_request_id

from wiki.api_v1.views import PageHtmlSerializer
from wiki.grids.utils import dummy_request_for_grids
from wiki.utils.blackbox import SERVICE_IP
from wiki.utils.tvm2 import get_service_ticket, get_user_ticket


def simulate_search(page):
    request = dummy_request_for_grids()

    s = PageHtmlSerializer(context={'request': request})
    bemjson = s.get_bemjson(request, page)

    url = '{protocol}://{host}/.search'.format(
        protocol=settings.WIKI_PROTOCOL,
        host=settings.NODEJS_FRONTEND_HOST,
    )

    headers = {
        'Content-Type': 'application/json',
        'X-Req-Id': _get_request_id(request),
    }

    user_ticket = get_user_ticket(
        user_ip=SERVICE_IP,
        server_host=settings.API_WIKI_HOST,
        oauth_token=settings.ROBOT_VIKA_TOKEN,
        session_id=None,
    )
    headers['x-ya-user-ticket'] = user_ticket
    headers['x-ya-service-ticket'] = get_service_ticket(settings.WIKI_FRONT_TVM2_CLIENT_ID)

    response = requests.post(
        url,
        headers=headers,
        json=bemjson,
        verify=False,
        # 99я персентиль сейчас - 5сек.
        # значит за 3 попытки по 20 сек каждая
        # все статистически будет укладываться
        timeout=20,
    )
    return response
