
import logging

import requests
from django.conf import settings
from ids.registry import registry

from wiki.utils.tvm2 import get_service_ticket

logger = logging.getLogger(__name__)

STAFF_CONNECTION_TIMEOUT = 5


def get_staff_repository(resource_type):
    return registry.get_repository(
        service='staff',
        resource_type=resource_type,
        user_agent='wiki',
        service_ticket=get_service_ticket(settings.STAFFAPI_TVM2_CLIENT_ID),
        timeout=STAFF_CONNECTION_TIMEOUT,
        retries=3,
    )


def get_staff_person_repo():
    return get_staff_repository('person')


def get_staff_group_repo():
    return get_staff_repository('group')


def get_staff_groupmembership_repo():
    return get_staff_repository('groupmembership')


def change_user_language(user, language, user_auth):
    try:
        resp = requests.post(
            url=f'{settings.STAFF_URL}api/change_staff/{user.staff.login}',
            headers={
                'X-Ya-User-Ticket': user_auth.tvm2_user_ticket,
                'X-Ya-Service-Ticket': get_service_ticket(settings.STAFF_TVM2_CLIENT_ID),
            },
            data={'lang_ui': language},
            verify=settings.INTERNAL_CA_PATH,
        )
        resp.raise_for_status()
    except requests.RequestException:
        logger.exception(f'Change staff request for `{user.staff.login}` failed')
        raise
