
import logging

from django.conf import settings

log = logging.getLogger(__name__)


def get_class_by_name(class_path):
    module_name, class_name = class_path.rsplit('.', 1)

    try:
        return getattr(__import__(module_name, {}, {}, [class_name]), class_name)
    except ImportError as e:
        log.error('Can not import class by path: %s (%s)', class_path, e)
        raise


STORAGE = get_class_by_name(settings.STORAGE_CLASS)()
