from wiki.utils.translit import wiki_translit


def translit(tag, to_lower=True):
    """
    Транслитерировать все русские буквы и удалить все недопустимые символы в строке,
    включая начальный и конечный символ "/".
    Если to_lower=True, перевести результат в нижний регистр.
    """
    return wiki_translit(tag, to_lower).strip('/')


def remove_trailing_dots(tag):
    """
    Удаляет из тега первые и последние точки на всех уровнях. Например, "aaa.1./.bbb.2." -> "aaa.1/bbb.2"
    Если в теге встречается "/./", это будет заменено на один слеш
    """
    return '/'.join(chunk.strip('.') for chunk in tag.split('/') if chunk.strip('.'))


def tag_to_supertag(tag):
    """
    Возвращает супертэг для тэга.

    @type tag: basestring
    @rtype: basestring
    """
    return translit(remove_trailing_dots(tag))


def normalize_supertag(dirty_supertag: str):
    """
    Единственно верный способ приведения грязного supertag к чистому
    :param dirty_supertag:
    :return:
    """
    if dirty_supertag is None:
        return dirty_supertag
    return translit(remove_trailing_dots(dirty_supertag))
