
import functools

from wiki.base_celery_task import CallableTask
from wiki.utils import lock


class LockedCallableTask(CallableTask):
    """
    Класс-обертка с локами над коллабл объектом.
    Имя лока может генерироваться из шаблона.
    """

    abstract = True

    lock_name_tpl = None

    def __call__(self, *args, **kwargs):
        """
        Взять лок, вернуть результат коллабл или пустой тупль, если лок взят.
        """
        if self._get_app().conf.CELERY_TASK_ALWAYS_EAGER or self._get_app().conf.CELERY_ALWAYS_EAGER:
            # при последовательном выполнении тасок не пользуемся локами из-за сильных тормозов в тестах
            return super(LockedCallableTask, self).__call__(*args, **kwargs)
        else:
            lock_name = self.lock_name_tpl.format(**kwargs) if self.lock_name_tpl else self.name

            try:
                self.logger.info('Acquiring %s for job %s' % (lock_name, self.name))
                return lock.execute_with_lock(
                    lock_name, functools.partial(super(LockedCallableTask, self).__call__, *args, **kwargs)
                )
            except lock.LockTaken:
                self.logger.info('Lock %s is already taken (job %s)' % (lock_name, self.name))
                return tuple()
            except lock.FailedToGetLockError as e:
                self.logger.exception('Failed to get lock %s (job %s)' % (lock_name, self.name))
                raise self.retry(exc=e, max_retries=3)
