
import logging

from wiki.notifications.queue import Queue
from wiki.notifications.tasks import NotifyPageSubscribersTask
from wiki.utils.db import on_commit
from wiki.utils.tasks.base import LockedCallableTask


class NotifyTask(LockedCallableTask):
    name = 'wiki.notify'
    logger = logging.getLogger('wiki.tasks')
    time_limit = 60 * 10

    def run(self, *args, **kwargs):
        """
        Асинхронно разослать письма.

        @param kwargs: simulate - не отсылать письма, только генерировать
        @param kwargs: keepletters - не помечать события обработанными.
        При следующем запуске они снова отправятся.
        """
        pages_with_events = Queue.page_ids_with_events()

        for page_id in pages_with_events:
            self.logger.info('creating task for page "%s"', page_id)
            task = NotifyPageSubscribersTask()
            on_commit(lambda: task.delay(page_id=page_id, options=kwargs))
