
import logging

from wiki.utils.db import on_commit
from wiki.utils.tasks.base import LockedCallableTask
from wiki.utils.tasks.sync_single_grid import SyncGrid


class SyncAllGrids(LockedCallableTask):
    """
    Ставит таску SyncGrid для всех табличных списков.
    """

    name = 'wiki.sync_all_grids'
    logger = logging.getLogger('celery.sync_grids')
    time_limit = 60 * 5

    def run(self, *args, **kwargs):
        from wiki.grids.models import Grid

        grids = Grid.active.values_list('id', flat=True)
        for grid_id in grids:
            task = SyncGrid()
            on_commit(lambda: task.delay(grid_id, simulate=False))
