
import logging

from django.db.transaction import atomic

from wiki.base_celery_task import CallableTask
from wiki.utils.backports.mds_compat import APIError


class SyncGrid(CallableTask):
    name = 'wiki.sync_single_grid'
    logger = logging.getLogger('celery.sync_grids')
    time_limit = 60 * 5

    @atomic
    def run(self, grid_id, simulate=False, *args, **kwargs):
        from wiki.grids.models import Grid

        try:
            grid = Grid.objects.get(id=grid_id)
        except Grid.DoesNotExist:
            self.logger.info('Grid %d has been deleted, stopping', grid_id)
            return

        try:
            result = grid.sync_data()
        except APIError:
            self.logger.exception(
                'Cannot read grid from storage, id="%s", storage_id="%s"', grid.id, grid.mds_storage_id
            )
            return

        if result is not None:
            # Что-то было сделано на самом деле.
            self.logger.debug('Grid "%d" has been updated', grid.id)
            grid.save()
