"""
    Тег fetch_setting вставляет в шаблон указанную настройку из
    django.conf.settings.

    Пример:
        {% load fetch_setting %}
        {% fetch_setting INSTALLED_APPS %}
        {% for app in INSTALLED_APPS %} ...

    Если настройка отсутствует, в контексте шаблона будет
    создана переменная с заданным именем и значением None.
"""

from django import template
from django.conf import settings

register = template.Library()


@register.tag
def fetch_setting(parser, token):
    tag_parts = token.split_contents()
    if len(tag_parts) < 2:
        raise template.TemplateSyntaxError('tag fetch_setting requires name of var')
    var = tag_parts[1]
    if var[0] in ('"', "'") or var[-1] in ('"', "'"):
        raise template.TemplateSyntaxError('don\'t quote var name in tag fetch_setting')
    return FetchSetting(var)


class FetchSetting(template.Node):
    def __init__(self, var):
        self.var = var

    def render(self, context):
        context[self.var] = getattr(settings, self.var, None)
        return ''
