
import logging
import time
from functools import wraps

from django.conf import settings

logger = logging.getLogger('wiki.timer')


def track_time(func):
    """
    Track function execution time.
    """

    @wraps(func)
    def wrapper(*args, **kwargs):
        r_started = time.time()
        result = func(*args, **kwargs)

        if settings.ENABLE_PROFILER:
            real = time.time() - r_started

            full_func_name = (func.__module__ or '') + '.' + func.__name__

            # template with function module and name
            logger.debug('%s operation done in %.4f secs', full_func_name, real)

        return result

    return wrapper
