import json
import logging

from django.conf import settings
from django.http import HttpResponse

logger = logging.getLogger(__name__)


def render_to_json(data, jsonify=True, cls=HttpResponse):
    """
    Shortcut dumps data to json and adding right headers for json response

    @param data: Object for serializing to json. If is instance of HttpResponse -- will be simply returned
    @param jsonify: do we need to serialize data to json ?
    @param cls: Class to be used instead of HttpResponse. If None, obj will be simply returned

    @rtype: HttpResponse
    @return: response with serialized to json object and json headers
    """
    indent = 4 if settings.DEBUG else None

    # serialize to json only if jsonify = False
    if jsonify:
        data = json.dumps(data, indent=indent)

    return cls(data, content_type='application/json')
