import logging

from .shortcuts import get_tracker_queues_repository
from ids import exceptions

logger = logging.getLogger(__name__)


def is_startrek_queue_exist(queue_key):
    try:
        get_tracker_queues_repository().get({'id': queue_key})
    except exceptions.BackendError as exc:
        if exc.status_code == 404:
            return False
        elif exc.status_code == 403:  # парсер иногда парсит то что не является тикетом - и ходит в стартрек падая с 403
            return False
        else:
            logger.exception('Error while checking queue %s existence' % queue_key)
            raise
    return True
