import logging

from ..issue_processor import IssueProcessor

logger = logging.getLogger(__name__)


class GridIssueProcessor(IssueProcessor):
    expected_st_fields = (
        'status',
        'type',
        'priority',
        'assignee',
        'createdBy',
        'summary',
        'createdAt',
        'updatedAt',
        'originalEstimation',
        'fixVersions',
        'components',
        'storyPoints',
    )

    @classmethod
    def process(cls, issue_data):
        try:
            return {
                'status_name': cls.display(issue_data['status'], 'en'),
                'status_icon': None,
                'type_name': cls.display(issue_data['type'], 'en'),
                'type_icon': None,
                'priority_name': cls.display(issue_data['priority'], 'en'),
                'priority_icon': None,
                'assignee': cls.process_user(issue_data, 'assignee'),
                'reporter': cls.process_user(issue_data, 'createdBy'),
                'summary': issue_data['summary'],
                'created_at': cls.process_dateteime(issue_data['createdAt']),
                'modified_at': cls.process_dateteime(issue_data['updatedAt']),
                'original_estimation': cls.process_duration(issue_data['originalEstimation']),
                'fix_versions': [cls.display(value, 'en') for value in issue_data['fixVersions']],
                'components': [cls.display(value, 'en') for value in issue_data['components']],
                'story_points': issue_data['storyPoints'],
            }
        except (KeyError, ValueError) as exc:
            logger.exception(exc)
        return None
