from unittest.mock import MagicMock

from ids.exceptions import EmptyIteratorError, IDSException


class ReferenceMockObject(dict):
    """
    Аналог объекта Reference из пакета startrek-python-client, который возвращается сейчас из ids_startrek2.
    """

    def __getattr__(self, key):
        return self.get(key)


class ResourceMockObject(object):
    """
    Аналог объекта Resource из пакета startrek-python-client, который возвращается сейчас из ids_startrek2.
    """

    def __init__(self, data):
        self._data = data

    def __dir__(self):
        return sorted(set(self._data.keys()))

    def __getattr__(self, key):
        if key in self._data:
            value = self._data[key]
            if isinstance(value, dict):
                value = ReferenceMockObject(**value)
            if isinstance(value, list):
                value = [ReferenceMockObject(item) for item in value]
            return value
        else:
            raise AttributeError(key)

    def __getitem__(self, key):
        try:
            return self.__getattr__(key)
        except AttributeError as e:
            raise KeyError(str(e))


class MockQueuesCollection(MagicMock):
    def get(self, lookup):
        if lookup.get('id') == 'STARTREK':
            return {
                'id': '4ff3009ce4b0d1fcead11017',
                'key': 'STARTREK',
                'name': 'Стартрек',
            }
        raise IDSException('Unknown mock project')

    def get_all(self, **parameters):
        return [
            {
                'id': '4ff3009ce4b0d1fcead11017',
                'key': 'STARTREK',
                'name': 'Стартрек',
            },
        ]


class MockIssuesCollection(MagicMock):
    def get_all(self, **parameters):
        # максимум значений
        # минимум значений
        st_100 = ResourceMockObject(
            {
                'id': '51f13720f2d2d202c5660100',
                'key': 'STARTREK-100',
                'summary': 'killa',
                'description': 'st 100 desc',
                'status': {
                    'display': {'ru': '\u0417\u0430\u043a\u0440\u044b\u0442', 'en': 'Closed'},
                    'self': 'https://st-api.test.yandex-team.ru/v2/statuses/1',
                    'id': '1',
                    'key': 'closed',
                },
                'resolution': {
                    'display': {'ru': '\u0420\u0435\u0448\u0435\u043d', 'en': 'Fixed'},
                    'self': 'https://st-api.test.yandex-team.ru/v2/resolutions/4',
                    'id': '4',
                    'key': 'fixed',
                },
                'type': {'display': {'en': 'Task'}},
                'priority': {'display': {'en': 'Critical'}},
                'assignee': {'id': 'chapson', 'display': {'en': 'chapson'}},
                'createdBy': {'id': 'thasonic'},
                'createdAt': '2013-06-12T15:12:39.186+0000',
                'updatedAt': '2015-04-06T07:52:56.650+0000',
                'originalEstimation': 'P3W4D',
                'fixVersions': [
                    {
                        'self': 'https://st-api.test.yandex-team.ru/v2/versions/213',
                        'id': '213',
                        'display': {'en': 'External wiki formatter', 'ru': 'Внешний вики-форматер'},
                    },
                    {
                        'self': 'https://st-api.test.yandex-team.ru/v2/versions/220',
                        'id': '220',
                        'display': {'en': 'Поддержка', 'ru': 'Поддержка'},
                    },
                ],
                'components': [
                    {
                        'self': 'https://st-api.test.yandex-team.ru/v2/components/33',
                        'id': '33',
                        'display': {'en': '% Formatter', 'ru': '% Форматтер'},
                    },
                    {
                        'self': 'https://st-api.test.yandex-team.ru/v2/components/22',
                        'id': '2',
                        'display': {'en': '% Фронтенд и Вёрстка', 'ru': '% Фронтенд и Вёрстка'},
                    },
                ],
                'storyPoints': '3.5',
                'aliases': [],
            }
        )
        st_101 = ResourceMockObject(
            {
                'id': '51f13720f2d2d202c5660101',
                'key': 'STARTREK-101',
                'summary': 'gorilla',
                'description': None,
                'status': {
                    'display': {'ru': '\u0417\u0430\u043a\u0440\u044b\u0442', 'en': 'Closed'},
                    'self': 'https://st-api.test.yandex-team.ru/v2/statuses/1',
                    'id': '1',
                    'key': 'closed',
                },
                'resolution': None,
                'type': {'display': {'en': 'Task'}},
                'priority': {'display': {'en': 'Critical'}},
                'assignee': None,
                'createdBy': {'id': 'thasonic'},
                'createdAt': '2013-06-12T15:12:39.186+0000',
                'updatedAt': '2015-04-06T07:52:56.650+0000',
                'originalEstimation': None,
                'fixVersions': [],
                'components': [],
                'aliases': [],
                'storyPoints': None,
            }
        )
        result = []
        keys = parameters['keys']
        for key in keys.split(','):
            if key == 'STARTREK-100':
                result.append(st_100)
            if key == 'STARTREK-101':
                result.append(st_101)
        if not result:
            raise EmptyIteratorError

        return result
