from wiki.utils.features.get_features import get_wiki_features
from wiki.utils.tracker.mocks import MockIssuesCollection, MockQueuesCollection

from .get_repo import get_tracker_client
from yandex_tracker_client import collections


def get_tracker_issues_repository(user_auth=None) -> collections.Issues:
    if get_wiki_features().mock_tracker:
        return MockIssuesCollection()

    return get_tracker_client(user_auth).issues


def get_tracker_queues_repository(user_auth=None) -> collections.Queues:
    if get_wiki_features().mock_tracker:
        return MockQueuesCollection()

    return get_tracker_client(user_auth, as_service=True).queues
