from django.conf import settings
from wiki.utils.blackbox import get_users_data_by_uids
import logging

logger = logging.getLogger(__name__)


def get_users_logins_by_uids(uids):
    """
    Получить логины пользователей из blackbox по их uid.

    @param uids: список uid пользователей

    @return словарь, где ключ - это uid пользователя, а значение - его логин
    """
    if not uids:
        return {}

    uid_2_login_dict = {}
    users_data = get_users_data_by_uids(uids)

    for user_data in users_data:
        login = user_data.login
        if not login:
            logger.info('User with uid "%s" doesnt exists', user_data.uid)
            continue

        if settings.IS_BUSINESS:
            login = login.split('@')[0]

        uid_2_login_dict[user_data.uid] = login

    return uid_2_login_dict
