

from django.conf import settings
from tvm2 import TVM2


class TVM2Error(Exception):
    pass


def get_tvm2_client():
    return TVM2(
        client_id=settings.YAUTH_TVM2_CLIENT_ID,
        secret=settings.YAUTH_TVM2_SECRET,
        blackbox_client=settings.TVM2_BLACKBOX_CLIENT,
        allowed_clients=settings.YAUTH_TVM2_ALLOWED_CLIENT_IDS,
        destinations=settings.TVM2_DESTINATIONS,
    )


def parse_user_ticket(user_ticket):
    tvm2_client = get_tvm2_client()
    return tvm2_client.parse_user_ticket(user_ticket)


def get_user_ticket(user_ip, server_host, oauth_token, session_id):
    tvm2_client = get_tvm2_client()
    user_ticket = tvm2_client.get_user_ticket(user_ip, server_host, oauth_token, session_id)
    if not user_ticket:
        raise TVM2Error('Can\'t get user ticket from blackbox')
    return user_ticket


def get_service_ticket(client_id):
    tvm2_client = get_tvm2_client()
    service_tickets = tvm2_client.get_service_tickets(client_id)
    service_ticket = service_tickets.get(client_id)
    if not service_ticket:
        raise TVM2Error('Can\'t get service ticket for client_id={}'.format(client_id))
    return service_ticket
