from django.conf import settings
from django.core.validators import URLValidator
from django.core.exceptions import ValidationError
from urllib.parse import urlparse


def is_valid_url(url):
    validator = URLValidator()
    try:
        validator(url)
    except ValidationError:
        return False

    return True


def is_wiki_url(url):
    wiki_hosts = settings.FRONTEND_HOSTS or []

    parsed_url = urlparse(url)
    if parsed_url.hostname and parsed_url.hostname in wiki_hosts:
        return True

    return False
