from django.conf import settings
from django.shortcuts import redirect
from django.utils.http import urlencode


def redirect_with_return_path(request, to):
    """
    Средиректить (вернув django.http.HttpResponseRedirect)
    с сохранением текущего урла в get-параметре retpath.
    Урл, на который ведет редирект должен вернуть пользователя
    туда куда он шел после того как сделает свои дела.
    """
    to = str(to)  # it can be lazy at this point

    if to in request.get_full_path():
        # already redirected on required page
        return

    base_url = '{0}://{1}'.format(settings.WIKI_PROTOCOL, settings.NGINX_HOST)
    retpath = urlencode({'retpath': base_url + request.get_full_path()})
    return redirect(to=base_url + '/' + to + '?' + retpath)
