from django.conf import settings
from wiki.intranet.models import Staff
from wiki.org import org_user
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.users.models import User


def get_wiki_robot(organization: BaseOrganization = None) -> User | None:
    """
    Робот используется
     - для имперсонации если к нам пришел поиск
     -
    :return:
    """
    if settings.IS_BUSINESS:
        if organization:
            mdl = organization.get_users()
        else:
            mdl = org_user()
        return mdl.filter(dir_id=settings.ROBOT_DIR_ID).first()
    else:
        return Staff.objects.get(uid=settings.ROBOT_VIKA_UID).user
