import click

from intranet.wiki.tools.conf2wiki.importer import ConfluenceImporter
from intranet.wiki.tools.conf2wiki.configs import EMPTY_CFG

import urllib3
import yaml
from pathlib import Path


urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


def mkdirs(folder):
    p = Path(folder)
    p.mkdir(parents=True, exist_ok=True)
    (p / 'raw').mkdir(parents=True, exist_ok=True)
    data = EMPTY_CFG.dict()
    with open(p / 'config.yaml', 'w') as w:
        yaml.safe_dump(data, w)


@click.group(invoke_without_command=True)
@click.argument('folder', required=True)
@click.option('--mkdir', required=False, is_flag=True, help='Make dirs')
@click.option('--init', required=False, is_flag=True, help='Parse entities and prepare binaries')
@click.option('--attaches', required=False, is_flag=True, help='Parse entities and prepare binaries')
@click.option('--spaces', required=False, is_flag=True, help='Parse entities and prepare binaries')
@click.option('--skip', required=False, is_flag=True, help='Parse entities and prepare binaries')
@click.option('--only', required=False)
@click.option('--resume', required=False)
@click.option('--offset', required=False, default=0)
@click.option('--limit', required=False, default=100000000)
def main(folder, mkdir, init, attaches, spaces, skip, only, resume, offset, limit):
    if mkdir:
        mkdirs(folder)
        return
    if only and ',' in only:
        only = set(only.split(','))
    c = ConfluenceImporter(folder)
    if init:
        c.parse_entities()
    elif attaches:
        c.upload_attaches(offset, limit, only_space=only, resume_on=resume, skip=skip)
    elif spaces:
        c.prepare_spaces()
    else:
        c.convert_import(offset, limit, only_space=only, skip=skip)
