from pathlib import Path
from typing import Optional, List

from pydantic import BaseModel


class BaseCfg(BaseModel):
    org_id: str
    oauth: Optional[str]
    only: Optional[List[str]]

    users_bin: str = 'users.bin'
    content_bin: str = 'content.bin'
    lut_bin: str = 'lut.bin'
    pages_bin: str = 'pages.bin'

    tvm2: bool = False  # usually that is not what you want!


class Cfg(BaseCfg):
    path: Path
    xml_path: Path
    attachments_path: Path


EMPTY_CFG = BaseCfg(
    org_id='REPLACE_ME',
    oauth='REPLACE_ME',
)
