from dataclasses import dataclass
from enum import Enum


@dataclass
class B2BCreds:
    org_id: str
    uid: str = None
    cloud_uid: str = None


class ApiRequestFailed(Exception):
    status_code = 500
    error_code = 'API_EXCEPTION'
    message = ' API call failed'


class AuthMode(Enum):
    TVM2 = 'tvm2'
    OAUTH = 'oauth'
    NONE = 'none'


class Flavor(Enum):
    INTRANET = 'intranet'
    B2B = 'b2b'


class EnvType(Enum):
    TESTING = 'testing'
    PROD = 'prod'
    STAND = 'stand'
