from dataclasses import dataclass
from typing import Callable

from intranet.wiki.tools.wikiclient.consts import EnvType, Flavor
from intranet.wiki.tools.wikiclient.restapi_client import E2eTvmRestApi
from intranet.wiki.tools.wikiclient.wiki_restapi_client import WikiRestApi

get_wiki_test_intranet = lambda: WikiRestApi('https://wiki-api.test.yandex-team.ru/', '_api').tvm2_auth(
    '2021374', '2002678'
)
get_wiki_prod_intranet = lambda: WikiRestApi('https://wiki-api.yandex-team.ru/', '_api').tvm2_auth('2021376', '2002680')
get_wiki_b2b_preprod = (
    lambda: WikiRestApi('https://wiki-api.preprod.yandex.ru/', '_api')
    .tvm2_auth('2029492', '2028483')
    .as_org(WikiRestApi.SHAD)
)
get_wiki_b2b_prod = (
    lambda: WikiRestApi('https://wiki-api.yandex.ru/', '_api').tvm2_auth('2029494', '2002686').as_org(WikiRestApi.SHAD)
)

get_dc_test = lambda: E2eTvmRestApi('https://dc.test.yandex-team.ru/api/v1').tvm2_auth(
    '2002678', '2021374'
)  # wiki -> dc
get_dc_prod = lambda: E2eTvmRestApi('https://dc.yandex-team.ru/api/v1').tvm2_auth('2002680', '2021376')


@dataclass
class Services:
    wiki_api: WikiRestApi
    dc: E2eTvmRestApi


@dataclass
class ServiceFactory:
    wiki_api: Callable[[], WikiRestApi]
    dc: Callable[[], E2eTvmRestApi]

    def build(self) -> Services:
        return Services(
            self.wiki_api(),
            self.dc(),
        )


SVCS = {
    (EnvType.STAND, Flavor.INTRANET): ServiceFactory(wiki_api=get_wiki_test_intranet, dc=get_dc_test),
    (EnvType.TESTING, Flavor.INTRANET): ServiceFactory(wiki_api=get_wiki_test_intranet, dc=get_dc_test),
    (EnvType.PROD, Flavor.INTRANET): ServiceFactory(wiki_api=get_wiki_prod_intranet, dc=get_dc_prod),
    (EnvType.STAND, Flavor.B2B): ServiceFactory(wiki_api=get_wiki_b2b_preprod, dc=get_dc_test),
    (EnvType.TESTING, Flavor.B2B): ServiceFactory(wiki_api=get_wiki_b2b_preprod, dc=get_dc_test),
    (EnvType.PROD, Flavor.B2B): ServiceFactory(wiki_api=get_wiki_b2b_prod, dc=get_dc_prod),
}


def get_contour(e: EnvType = EnvType.TESTING, f: Flavor = Flavor.INTRANET, stand_user: str = None) -> Services:
    mdl = SVCS[(e, f)].build()
    if stand_user:  # ゴ ゴ ゴ ゴ
        mdl.wiki_api.host = mdl.wiki_api.host.replace('wiki-api', f'{stand_user}.wiki-api')

    return mdl
