import os
import subprocess


def make_service_ticket(src, dst):
    # tvmknife unittest service
    q = dict(**os.environ)

    # ya tool это тоже приложение на питоне, поэтому эти переменные окружения будут его сбивать:
    del q['Y_PYTHON_ENTRY_POINT']
    del q['Y_PYTHON_SOURCE_ROOT']
    del q['PYTHONPATH']

    # доотладим когда опять кеши устареют
    result = subprocess.run(
        ['ya', 'tool', 'tvmknife', 'get_service_ticket', 'sshkey', '-s', src, '-d', dst], capture_output=True, env=q
    )
    if result.returncode != 0:
        raise ValueError(result.stderr.decode())

    return result.stdout.decode().strip()
