from intranet.wiki.tools.wikiclient.consts import AuthMode
from intranet.wiki.tools.wikiclient.restapi_client import E2eTvmRestApi


class FixtureCtxManager:
    def __init__(self, api):
        self.api = api

    def __enter__(self):
        self._run_id = self.api.prepare_fixtures()
        prefix = f'e2e/{self._run_id}/'
        print(f'entering {self._run_id}; all pages should have prefix {prefix}')
        return prefix

    def __exit__(self, *_):
        if self._run_id:
            print(f'cleaning up {self._run_id}')
            self.api.cleanup_fixtures(self._run_id)


class WikiRestApi(E2eTvmRestApi):
    org_id = None
    SHAD = '3668647'
    YA_TEAM_FED = '5917351'

    def __init__(self, host, default_api=''):
        super().__init__(host, default_api)

    def as_org(self, org_id):
        self.org_id = org_id
        return self

    def inject_headers(self, headers):
        if self.auth != AuthMode.NONE:
            self.auth_fn[self.auth](self, headers)

        if self.org_id:
            headers['X-ORG-ID'] = self.org_id

    def page_exists(self, supertag):
        code, response = self.api_call('post', 'svc/e2e/.exists', {'supertag': supertag}, api='_api', parse_json=True)
        return response['data']['exists']

    def fixture_ctx(self):
        return FixtureCtxManager(self)

    def prepare_fixtures(self):
        code, response = self.api_call('post', 'svc/e2e/.prepare', {}, api='_api')
        return response['data']['run_id']

    def cleanup_fixtures(self, run_id):
        code, response = self.api_call('post', 'svc/e2e/.cleanup', {'run_id': run_id}, api='_api')
        return 200 == code
