#!/bin/bash

MSGFMT=$(which msgfmt)

TANKER_EMAIL_KEYSET='Email'
TANKER_SMS_KEYSET='Sms'
TANKER_API_MESSAGES_KEYSET='api_messages'

TRANSLATIONS_ROOT=${WWW_DIR}/i18n

if [ "$MSGFMT" = "" ] ; then
  echo 'msgfmt is missing, try brew link gettext --force'
  exit 1
fi

for keyset in ${TANKER_EMAIL_KEYSET} ${TANKER_SMS_KEYSET} ${TANKER_API_MESSAGES_KEYSET}
do
  find ${TRANSLATIONS_ROOT} -name ${keyset,,}.po -execdir msgfmt ${keyset,,}.po -o ${keyset,,}.mo \;
done

exit 0

