#!/bin/bash
set -e

# Fix permissions for push-client config
chmod 644 /etc/yandex/statbox-push-client/push-client.yaml
# Add push-client secret to config (start-stop-daemon does not support env vars after chuid
echo "  tvm-secret: ${PUSH_CLIENT_TVM_SECRET}" >> /etc/yandex/statbox-push-client/push-client.yaml
mkdir -p /var/spool/push-client
mkdir -p /var/run/statbox
chown statbox:statbox /var/spool/push-client /var/run/statbox
# Start service

if [[ $NEED_PUSH_CLIENT == "true" ]]; then
#    service statbox-push-client start
    /usr/bin/push-client -w --pid /var/run/statbox/push-client.pid -c /etc/yandex/statbox-push-client/push-client.yaml
fi

cd /root/app

service cron start

if [[ $NGINX_PROXY == "true" ]]; then
    BIND_TO_ADDRESS='[::]:8080'
    service nginx start
else
    BIND_TO_ADDRESS='[::]:80'
fi

if [[ ${WORKER_MODE} ]]; then
    echo "Start only task queue worker"
    /root/app/yandex-directory-main --ini app-mule.uwsgi \
                                    --http-socket "$BIND_TO_ADDRESS" \
                                    --mule=worker.py \
                                    ${UWSGI_OPTIONS}

# Y_PYTHON_ENTRY_POINT="intranet.yandex_directory.src.worker:run_worker_uwsgi" /root/app/yandex-directory-main
# run_scheduler_uwsgi
# run_short_scheduler_uwsgi
# или просто в --mule опцию запихнуть строку выше
elif [[ ${CONSUMER_MODE} ]]; then
    echo "Start only as logbroker consumer"
    /root/app/yandex-directory-main --ini app-mule.uwsgi \
                                    --http-socket "$BIND_TO_ADDRESS" \
                                    --mule=consumer.py \
                                    ${UWSGI_OPTIONS}



elif [[ ${SCHEDULER_MODE} ]]; then
    echo "Start only scheduler"
    /root/app/yandex-directory-main --ini app-mule.uwsgi \
                                    --http-socket "$BIND_TO_ADDRESS" \
                                    --mule=scheduler.py \
                                    --mule=short-scheduler.py \
                                    ${UWSGI_OPTIONS}

else
    #echo "Build docs"
    #./build_docs.sh
    echo "Start uwsgi"
    /root/app/yandex-directory-main --ini app.uwsgi \
                                    --http-socket "$BIND_TO_ADDRESS" \
                                    ${UWSGI_OPTIONS}

fi
