#!/bin/bash

# включим вывод команд
set -x
# и будем падать если только хоть где-то произойдёт ошибка
set -e

# libpcre3 нужна для того чтобы uwsgi собрался с поддержкой prce, которая требуется для internal routing-а
apt-get update
apt-get install -y --force-yes libpcre3 libpcre3-dev

# ждем, что в качестве аргумента будет передана версия, которую надо установить
VERSION=$1
if [ "$VERSION" == "" ]; then
    echo "Please, specify a version of UWSGI."
    exit 1
fi

mkdir /tmp/build-uwsgi
cd /tmp/build-uwsgi
git clone https://github.com/unbit/uwsgi
cd uwsgi
git checkout $VERSION
make
cp uwsgi /usr/local/bin

cd /
rm -fr /tmp/build-uwsgi
