#!/bin/bash

function find_ssh_dir () {
    # Возьмём самую недавно созданную директорию с сокетом
    DIR_NAME=$(ls -t /tmp/qloud | grep 'ssh-[0-9]' | head -1)
    [ -n "$DIR_NAME" ] && echo "/tmp/qloud/${DIR_NAME}"
}

function find_ssh_sock () {
    DIR=$(find_ssh_dir)
    if [ -n "$DIR" ]
    then
	FILENAME=$(sudo ls "$DIR" | head -1)
	[ -n "$FILENAME" ] && echo "$DIR/$FILENAME"
    fi
	
}

function restore_ssh_auth_sock () {
    # Устанавливаем переменную окружения для ssh_agent если она вдруг протерялась
    if [ -z "$SSH_AUTH_SOCK" ]
    then
	SOCK=$(find_ssh_sock)
	if [ -n "$SOCK" ]
	then
	    export SSH_AUTH_SOCK=$SOCK
	fi
    fi
}


restore_ssh_auth_sock
