### API Яндекс.Директории

#### Сохранении истории в базу и отправка уведомлений
Каждое изменение объектов в базе записывает в таблицу для истории. Такие
изменения будем называть "действия", они записываются в таблицу actions.
Каждое действие увеличивают номер ревизии организации. По ним можно понять
кто когда выполнил какое действие, составить аудит-лог,
а также найти все изменения от любой версии до текущей.
Поддерживаются действия:
organization_add
user_add
user_modify
department_add
group_add

Список будет долняться.
Действие сохраняется в виде записи с полями:

 org_id (integer)
 revision (integer) - номер ревиции, единый на организацию
 name(character varying(255)) - название действия
 author_id (bigint) - uid кто выполнил действие
 object (jsonb) - объект, который был изменён, уже в измененном состоянии
 object_type (character varying(255)) - тип объекта из object.  Множество значений {"user", "department", "group", "resource"}. Тип объекта можно понять по названию события, например, user_add, относиться в типу user. Отдельное поле добавлено для быстрых выборок в базе.
 old_object (jsonb) - значение объекта до изменений. Может быть пустым
 объектом для действий добавления и пр.
 timestamp (timestamp)

Каждое действие может порождать событие или несколько событий.
На событие можно подписаться и получить данные когда оно произойдёт.
Цепочка порождения событий:
#TODO
Событие сохраняется с таблицу events с полями:
 org_id (integer)
 revision (integer) - номер ревиции, единый на организацию
 name(character varying(255)) - название действия
 content (jsonb) - дополнительные данные. Информация о предыдушем состоянии,
  признак косвенных измениний.
 object_type (character varying(255)) -  тип объекта из object. Множество значений {"user", "department", "group", "resource"}. Тип объекта можно понять по названию события, например, user_add, относиться в типу user. Отдельное поле добавлено для быстрых выборок в базе.
 object (jsonb) - объект, к которому относится событие
 timestamp (timestamp)
