#!/bin/bash

function check_trunk {
    if [[ `arc st | head -n1 | sed 's/On branch //g'` != 'trunk' ]]; then
        echo You need checkout to trunk!
        exit 1
    fi
}

case $1 in
build)
    check_trunk
    ../../ya tool releaser release-changelog --non-interactive --pull-vcs
    ../../ya tool releaser build --buildfile docker_package.json --image registry.yandex.net/workspace/directory
    ../../ya tool releaser push --image registry.yandex.net/workspace/directory
;;
buildCurrent)
    VERSION=`arc br | grep '*' | sed 's/\* //'`-`date +"%s"`
    IMAGE_ARGS="--image registry.yandex.net/workspace/directory --version $VERSION"
    ../../ya tool releaser build --buildfile docker_package.json $IMAGE_ARGS
    ../../ya tool releaser push $IMAGE_ARGS
;;
deployCurrentToTesting)
    VERSION=`arc br | grep '*' | sed 's/\* //'`-`date +"%s"`
    IMAGE_ARGS="--image registry.yandex.net/workspace/directory --version $VERSION"
    ../../ya tool releaser build --buildfile docker_package.json $IMAGE_ARGS
    ../../ya tool releaser push $IMAGE_ARGS
    ../../ya tool releaser deploy $IMAGE_ARGS --stage directory-testing --box box --deploy-units 'backend,scheduler,worker,consumer' --deploy-comment-format "Deploy current version {version}"
;;
deployCurrentToPreprod)
    VERSION=`arc br | grep '*' | sed 's/\* //'`-`date +"%s"`
    IMAGE_ARGS="--image registry.yandex.net/workspace/directory --version $VERSION"
    ../../ya tool releaser build --buildfile docker_package.json $IMAGE_ARGS
    ../../ya tool releaser push $IMAGE_ARGS
    ../../ya tool releaser deploy $IMAGE_ARGS --stage directory-preprod --box box --deploy-units 'backend,backend_standalone,scheduler,worker' --deploy-comment-format "Deploy current version {version}"
;;
deployCurrentToPreprodSA)
    VERSION=`arc br | grep '*' | sed 's/\* //'`-`date +"%s"`
    IMAGE_ARGS="--image registry.yandex.net/workspace/directory --version $VERSION"
    ../../ya tool releaser build --buildfile docker_package.json $IMAGE_ARGS
    ../../ya tool releaser push $IMAGE_ARGS
    ../../ya tool releaser deploy $IMAGE_ARGS --stage directory-preprod --box box --deploy-units 'backend_standalone' --deploy-comment-format "Deploy current version {version}"
;;
deployCurrentToProductionShell)
    VERSION=`arc br | grep '*' | sed 's/\* //'`-`date +"%s"`
    IMAGE_ARGS="--image registry.yandex.net/workspace/directory --version $VERSION"
    ../../ya tool releaser build --buildfile docker_package.json $IMAGE_ARGS
    ../../ya tool releaser push $IMAGE_ARGS
    ../../ya tool releaser deploy $IMAGE_ARGS --stage directory_int-production --box box --deploy-units 'shell' --deploy-comment-format "Deploy current version {version} to shell"
;;
deployCurrentToProductionWorkers)
    VERSION=`arc br | grep '*' | sed 's/\* //'`-`date +"%s"`
    IMAGE_ARGS="--image registry.yandex.net/workspace/directory --version $VERSION"
    ../../ya tool releaser build --buildfile docker_package.json $IMAGE_ARGS
    ../../ya tool releaser push $IMAGE_ARGS
    ../../ya tool releaser deploy $IMAGE_ARGS --stage directory_int-production --box box --deploy-units 'worker' --deploy-comment-format "Deploy current version {version} to shell"
;;
deployShell)
    check_trunk
    ../../ya tool releaser deploy --image registry.yandex.net/workspace/directory --stage directory_int-production --box box --deploy-units 'shell' --deploy-comment-format "Releasing version {version} to shell"
;;
deployStandalone)
    check_trunk
    ../../ya tool releaser deploy --image registry.yandex.net/workspace/directory --stage directory_int-production --box box --deploy-units 'backend_standalone' --deploy-comment-format "Releasing version {version} to standalone"
;;
deployTesting)
    check_trunk
    ../../ya tool releaser deploy --image registry.yandex.net/workspace/directory --stage directory-testing --box box --deploy-units 'backend,scheduler,worker,consumer'
;;
deployPreprod)
    check_trunk
    ../../ya tool releaser deploy --image registry.yandex.net/workspace/directory --stage directory-preprod --box box --deploy-units 'backend,backend_standalone,scheduler,worker'
;;
deployProduction)
    check_trunk
    ../../ya tool releaser deploy --image registry.yandex.net/workspace/directory --stage directory_int-production --box box --deploy-units 'backend,consumer,scheduler,worker,shell'
    ../../ya tool releaser deploy --image registry.yandex.net/workspace/directory --stage directory_ext-production --box box --deploy-units 'backend'
;;
esac

rm directory.*.tar.gz &> /dev/null
