def iterate_over_org_ids(shard, chunk_size=10):
   from intranet.yandex_directory.src.yandex_directory.common.db import get_main_connection
   max_org_id = 0
   query = """
      SELECT id FROM organizations
       WHERE NOT EXISTS (
          SELECT 1
            FROM organization_services
           WHERE organization_services.org_id = organizations.id
             AND service_id = 142)
         AND id > %s
      ORDER BY id
      LIMIT %s
   """
   while True:
      with get_main_connection(shard=shard) as main_connection:
         rows = main_connection.execute(query, (max_org_id, chunk_size)).fetchall()
         if not rows:
            print('No orgs in shard', shard)
            return
         
         for row in rows:
            org_id = row[0]
            if org_id != 34:
               yield org_id
            max_org_id = org_id


def interleave(iterables):
   iterators = list(map(iter, iterables))
   to_remove = []
   
   while iterators:
      for iterator in iterators:
         try:
            yield next(iterator)
         except StopIteration:
            to_remove.append(iterator)
      if to_remove:
         iterators = [i
                      for i in iterators
                      if i not in to_remove]
         to_remove = []


def iterate_over_all_orgs():
   from itertools import repeat
   from intranet.yandex_directory.src.yandex_directory.common.db import (
      get_meta_connection,
      get_shard_numbers,
   )
   shards = sorted(set(get_shard_numbers()) - set(app.config['SHARDS_FOR_PORTAL']))
   
   with get_meta_connection() as meta_connection:
      cursor = meta_connection.execute('SELECT id FROM organizations WHERE ready = FALSE')
      not_ready = set(row[0] for row in cursor.fetchall())

      iterators = [
         list(zip(
            repeat(shard),
            iterate_over_org_ids(shard)
         ))
         for shard in shards
      ]
      return interleave(iterators)


def enable_forms(limit=100, delay=0.1):
    from time import sleep
    from tqdm import tqdm
    from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow, format_date
    from intranet.yandex_directory.src.yandex_directory.common.yt import utils as yt_utils
    from intranet.yandex_directory.src.yandex_directory.core.models.service import enable_service
    from intranet.yandex_directory.src.yandex_directory.common.db import (
       get_main_connection,
       get_meta_connection,
    )
    from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
    from itertools import islice
    from intranet.yandex_directory.src.yandex_directory.core.commands.enable_yaorg import get_admins
    
    service_slug = 'forms'
 
    with get_meta_connection() as meta_connection:
       service = ServiceModel(meta_connection).get_by_slug(service_slug)
       service_id = service['id']
 
    table_path = '//home/yandex-connect/{}/analytics/enable-{}/{}'.format(
       app.config['ENVIRONMENT'],
       service_slug,
       format_date(utcnow(), only_date=True),
    )
 
    with yt_utils.yt_client.Transaction() as yt_transaction, \
         yt_utils.with_table(table_path, org_id='int64', admin_email='string') as add_row:

       try:
          org_ids = iterate_over_all_orgs()
          if limit:
             org_ids = islice(org_ids, 0, limit)

          org_ids = tqdm(org_ids)

          for shard, org_id in org_ids:
             if delay:
                sleep(delay)

             with get_main_connection(shard=shard, for_write=True) as main_connection, \
                  get_meta_connection() as meta_connection:
                try:
                   enable_service(
                        meta_connection,
                        main_connection,
                        org_id,
                        service_slug,
                        author_id=None,
                        responsible_id=None,
                    )

                   admins = get_admins(meta_connection, main_connection, org_id)
                   if admins:
                      for admin_email in admins:
                         add_row(org_id=org_id, admin_email=admin_email)
                   else:
                       add_row(org_id=org_id, admin_email=None)
                except Exception as exc:
                    print('ERROR', org_id, exc)
                    log.trace().error('Unable to enable service')
       except KeyboardInterrupt:
          print('Exiting because keyboard interrupt and commiting YT transaction')


# Пример использования
enable_forms(limit=50000, delay=0.05)
