from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow, parse_date
from datetime import timedelta
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_main_connection,
    get_meta_connection,
    get_shard_numbers,
)

def get_day_before(for_date):
    for_date = parse_date(for_date)
    delta = timedelta(1)
    return str(for_date - delta)
    

def repair_shard(shard, for_date):
    with get_main_connection(shard=shard, for_write=True) as c:
        count = c.execute('select count(*) from organizations_analytics_info where for_date = %s', (for_date,)).fetchall()[0][0]
        if count == 0:
            query = """
INSERT INTO organizations_analytics_info
     SELECT id, registration_date, source, subscription_plan, language, tld, country, balance, first_debt_act_date, services, %(for_date)s, admins, deputy_admins, organization_type, vip, name, feature_ids FROM organizations_analytics_info where for_date = %(day_before)s
"""
            print('Fixing shard {0}'.format(shard))
            day_before = get_day_before(for_date)
            c.execute(query, for_date=for_date, day_before=day_before)
            count = c.execute('select count(*) from organizations_analytics_info where for_date = %s', (for_date,)).fetchall()[0][0]
        return count


def repair_analytics(for_date):
    """Чинит данные в YT.
       Если в каком-то из шардов не хватает данных в табличке organizations_analytics_info,
       то мы возьмём эти данные за предыдущий день. Увы, это лучшее, что можно сделать.
    """

    shards = get_shard_numbers()
    
    for shard in shards:
        print(repair_shard(shard, for_date))


def shard_info(shard, for_date):
    with get_main_connection(shard=shard, for_write=True) as c:
        count = c.execute('select count(*) from organizations_analytics_info where for_date = %s', (for_date,)).fetchall()[0][0]
        print('Shard {}: {}'.format(shard, count))


def show(for_date):
    shards = get_shard_numbers()
    
    for shard in shards:
        print(shard_info(shard, for_date))
