from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_main_connection,
    get_meta_connection,
    get_shard_numbers,
)

from intranet.yandex_directory.src.yandex_directory.core.models import TaskModel



def show_analytics_saving_status(task_id=None):
    with get_main_connection(shard=1) as main_connection:
        if task_id:
            task = TaskModel(main_connection) \
                .filter(id=task_id) \
                .one()
        else:
            tasks = TaskModel(main_connection) \
                .filter(task_name='intranet.yandex_directory.src.yandex_directory.core.utils.tasks.SaveAnalyticsToYTTask') \
                .order_by('-created_at') \
                .limit(10)
            # пропустим таски на копирование, запущенные вручную,
            # у них нет метаданных
            for task in tasks:
                if task['metadata']:
                    break
            else:
                task = None

        if task is None:
            print('Task not found.')
            return

        print('Main task: {} ({})'.format(task['id'], task['state']))

        meta = task['metadata']
        for shard, subtask in sorted(meta.items()):
            print('{}: {} {}'.format(
                shard,
                subtask['id'],
                subtask['state'],
            ))

        next_check_in = (task['start_at'] - utcnow()).total_seconds()
        if next_check_in > 0:
            print('Next check in {:.1f} seconds'.format(next_check_in))

        
