$(function () {
    var spec = SWAGGER_SPEC_PLACEHOLDER;
    var oauth_config = SWAGGER_OAUTH_CONFIG;

    window.swaggerUi = new SwaggerUi({
        spec: spec,
        url: window.location.href,
        validatorUrl: null,
        dom_id: "swagger-ui-container",
        supportedSubmitMethods: ['get', 'post', 'put', 'delete', 'patch'],
        apisSorter: "alpha",
        onComplete: function(swaggerApi, swaggerUi){
            if(typeof initOAuth == "function") {
                initOAuth({
                    clientId: "your-client-id",
                    realm: "your-realms",
                    appName: "your-app-name"
                });
            }

            $('pre code').each(function(i, e) {
                hljs.highlightBlock(e)
            });

            var item_to_append = $('.sphinxsidebarwrapper>ul>li>ul');

            $("#resources li.resource").each(function(key, item){
                var title = $.trim($(item).find('div.heading h2').text());

                // создаем по большому блоку на каждый ресурс
                var slugifiedTitle = slugify(title).toLocaleLowerCase();
                $(item).attr('id', slugifiedTitle);

                var newBlock = $('<li><a href="#' + slugifiedTitle + '">' + title + '</a><ul></ul></li>');
                item_to_append.append(newBlock);

                // создаем по маленькому подблоку на каждую ручку ресурса
                $(item).find('.endpoint').each(function(subItemKey, subItem){
                    var subTitle = $.trim($(subItem).find('.options').text());
                    var subTitleslugifiedTitle = slugify(subTitle).toLocaleLowerCase();

                    $(subItem).find('.operations').css('padding-left', 0);

                    $(subItem).prepend('<h4 style="margin-bottom: 30px;" class="anchor" id="' + subTitleslugifiedTitle + '"><a style="color: #000;" href="#' + subTitleslugifiedTitle + '">' + subTitle + '</a> <span class="anchor_char">¶</span></h4>');

                    newBlock.find('ul').append(
                        '<li><a href="#' + subTitleslugifiedTitle + '">' + subTitle + '</a></li>'
                    )
                });
            });

            $(".swagger-section .swagger-ui-wrap h2").css('font-size', '24px');

            // убираем ненужные тогглеры
            $('#resources_container .heading .options').remove();

            // убиваем поведение тогглеров
            $('.toggleOperation').removeAttr('href');
            $('.toggleOperation').removeClass('toggleOperation');

            $('.toggleEndpointList').removeAttr('href');
            $('.toggleEndpointList').removeClass('toggleEndpointList');


            //window.SwaggerTranslator.translate();

            // принудительно заставляем страницу прокрутиться до выбранного раздела
            // иначе, если кому-то дали ссылку на определенную ручку, он её не увидит,
            // ведь данные сваггера появляются на странице с задержкой
            if (location.hash != '') {
                console.log('Moving to ' + location.hash);
                console.log('Href is ' + location.href);

                function move_to_location () {
                    console.log('Actually moving');
                    location.href = location.href;
                }
                if (initOauthToken()){
                    location.href = location.href.replace(location.hash,"");
                }else {
                    setTimeout(move_to_location, 500);
                }
            } else {
                console.log('Not moving to ' + location.hash);
                console.log('Href is ' + location.href);
            }
            initUID();
            addApiKeyAuthorization();

        },
        onFailure: function(data) {
            log("Unable to Load SwaggerUI");
        },
        docExpansion: "full",
        apisSorter: "alpha"
    });

    function initUID() {
        var uid = $('#input_UID').val();
        if (!uid && $.cookie('swaggerUID')) {
            uid = $.cookie('swaggerUID');
            $('#input_UID').val(uid);
        }
        var token = $('#input_apiKey').val();
        if (!token && $.cookie('swaggerToken')) {
            token = $.cookie('swaggerToken');
            $('#input_apiKey').val(token);
        }
    }

    function initOauthToken() {
        var hash = window.location.hash.substr(1);
        if (hash !== ''){
            var params = new URLSearchParams(hash);
            var access_token =  params.get('access_token');
            if (access_token !== null){
                var oauth = 'OAuth ' + access_token;
                $('#input_apiKey').val(oauth);
                return true;
            }
        }
        return false;

    }

    function getOAuthToken() {
        var host = window.location.host;


        var oauth_host = oauth_config[host]['oauth_host'];
        var client_id =  oauth_config[host]['client_id'];
        var url = 'https://'+oauth_host+'/authorize?response_type=token&client_id='+client_id;

        window.location.href = url;
    }

    function addApiKeyAuthorization(){
        var key = $('#input_apiKey').val();

        if(key !== undefined) {
            var apiKeyAuth = new SwaggerClient.ApiKeyAuthorization("Authorization", key, "header");
            window.swaggerUi.api.clientAuthorizations.add("api_key", apiKeyAuth);
            $.cookie('swaggerToken', key);
            log("added key " + key);
        }

         var uid = $('#input_UID').val();
         if(uid !== undefined){
            var apiUID = new SwaggerClient.ApiKeyAuthorization("X-UID", uid, "header");
            window.swaggerUi.api.clientAuthorizations.add("api_uid", apiUID);
            var apiIP = new SwaggerClient.ApiKeyAuthorization("X-USER-IP", "127.0.0.1", "header");
            window.swaggerUi.api.clientAuthorizations.add("api_ip", apiIP);
            $.cookie('swaggerUID', uid);
            log("added uid " + uid);
        }

        var org_id = $('#input_ORGID').val();
        if(org_id && org_id.trim() != "") {
            var apiORGID = new SwaggerClient.ApiKeyAuthorization("X-ORG-ID", org_id, "header");
            window.swaggerUi.api.clientAuthorizations.add("api_org_id", apiORGID);
            log("added org_id " + org_id);
        }
    }

    $('#input_apiKey').change(addApiKeyAuthorization);
    $('#input_UID').change(addApiKeyAuthorization);
    $('#input_ORGID').change(addApiKeyAuthorization);
    $('#btn_OAUTH').click(getOAuthToken);

    window.swaggerUi.load();

    function log() {
        if ('console' in window) {
            console.log.apply(console, arguments);
        }
    }

    // https://github.com/simov/slugify/blob/master/lib/slugify.js
    function slugify(string, replacement) {
        var charMap = {
            // latin
            'À': 'A', 'Á': 'A', 'Â': 'A', 'Ã': 'A', 'Ä': 'A', 'Å': 'A', 'Æ': 'AE',
            'Ç': 'C', 'È': 'E', 'É': 'E', 'Ê': 'E', 'Ë': 'E', 'Ì': 'I', 'Í': 'I',
            'Î': 'I', 'Ï': 'I', 'Ð': 'D', 'Ñ': 'N', 'Ò': 'O', 'Ó': 'O', 'Ô': 'O',
            'Õ': 'O', 'Ö': 'O', 'Ő': 'O', 'Ø': 'O', 'Ù': 'U', 'Ú': 'U', 'Û': 'U',
            'Ü': 'U', 'Ű': 'U', 'Ý': 'Y', 'Þ': 'TH', 'ß': 'ss', 'à':'a', 'á':'a',
            'â': 'a', 'ã': 'a', 'ä': 'a', 'å': 'a', 'æ': 'ae', 'ç': 'c', 'è': 'e',
            'é': 'e', 'ê': 'e', 'ë': 'e', 'ì': 'i', 'í': 'i', 'î': 'i', 'ï': 'i',
            'ð': 'd', 'ñ': 'n', 'ò': 'o', 'ó': 'o', 'ô': 'o', 'õ': 'o', 'ö': 'o',
            'ő': 'o', 'ø': 'o', 'ù': 'u', 'ú': 'u', 'û': 'u', 'ü': 'u', 'ű': 'u',
            'ý': 'y', 'þ': 'th', 'ÿ': 'y', 'ẞ': 'SS',
            // greek
            'α':'a', 'β':'b', 'γ':'g', 'δ':'d', 'ε':'e', 'ζ':'z', 'η':'h', 'θ':'8',
            'ι':'i', 'κ':'k', 'λ':'l', 'μ':'m', 'ν':'n', 'ξ':'3', 'ο':'o', 'π':'p',
            'ρ':'r', 'σ':'s', 'τ':'t', 'υ':'y', 'φ':'f', 'χ':'x', 'ψ':'ps', 'ω':'w',
            'ά':'a', 'έ':'e', 'ί':'i', 'ό':'o', 'ύ':'y', 'ή':'h', 'ώ':'w', 'ς':'s',
            'ϊ':'i', 'ΰ':'y', 'ϋ':'y', 'ΐ':'i',
            'Α':'A', 'Β':'B', 'Γ':'G', 'Δ':'D', 'Ε':'E', 'Ζ':'Z', 'Η':'H', 'Θ':'8',
            'Ι':'I', 'Κ':'K', 'Λ':'L', 'Μ':'M', 'Ν':'N', 'Ξ':'3', 'Ο':'O', 'Π':'P',
            'Ρ':'R', 'Σ':'S', 'Τ':'T', 'Υ':'Y', 'Φ':'F', 'Χ':'X', 'Ψ':'PS', 'Ω':'W',
            'Ά':'A', 'Έ':'E', 'Ί':'I', 'Ό':'O', 'Ύ':'Y', 'Ή':'H', 'Ώ':'W', 'Ϊ':'I',
            'Ϋ':'Y',
            //turkish
            'ş':'s', 'Ş':'S', 'ı':'i', 'İ':'I', 'ç':'c', 'Ç':'C', 'ü':'u', 'Ü':'U',
            'ö':'o', 'Ö':'O', 'ğ':'g', 'Ğ':'G',
            // russian
            'а':'a', 'б':'b', 'в':'v', 'г':'g', 'д':'d', 'е':'e', 'ё':'yo', 'ж':'zh',
            'з':'z', 'и':'i', 'й':'j', 'к':'k', 'л':'l', 'м':'m', 'н':'n', 'о':'o',
            'п':'p', 'р':'r', 'с':'s', 'т':'t', 'у':'u', 'ф':'f', 'х':'h', 'ц':'c',
            'ч':'ch', 'ш':'sh', 'щ':'sh', 'ъ':'u', 'ы':'y', 'ь':'', 'э':'e', 'ю':'yu',
            'я':'ya',
            'А':'A', 'Б':'B', 'В':'V', 'Г':'G', 'Д':'D', 'Е':'E', 'Ё':'Yo', 'Ж':'Zh',
            'З':'Z', 'И':'I', 'Й':'J', 'К':'K', 'Л':'L', 'М':'M', 'Н':'N', 'О':'O',
            'П':'P', 'Р':'R', 'С':'S', 'Т':'T', 'У':'U', 'Ф':'F', 'Х':'H', 'Ц':'C',
            'Ч':'Ch', 'Ш':'Sh', 'Щ':'Sh', 'Ъ':'U', 'Ы':'Y', 'Ь':'', 'Э':'E', 'Ю':'Yu',
            'Я':'Ya',
            // ukranian
            'Є':'Ye', 'І':'I', 'Ї':'Yi', 'Ґ':'G', 'є':'ye', 'і':'i', 'ї':'yi', 'ґ':'g',
            // czech
            'č':'c', 'ď':'d', 'ě':'e', 'ň': 'n', 'ř':'r', 'š':'s', 'ť':'t', 'ů':'u',
            'ž':'z', 'Č':'C', 'Ď':'D', 'Ě':'E', 'Ň': 'N', 'Ř':'R', 'Š':'S', 'Ť':'T',
            'Ů':'U', 'Ž':'Z',
            // polish
            'ą':'a', 'ć':'c', 'ę':'e', 'ł':'l', 'ń':'n', 'ó':'o', 'ś':'s', 'ź':'z',
            'ż':'z', 'Ą':'A', 'Ć':'C', 'Ę':'e', 'Ł':'L', 'Ń':'N', 'Ś':'S',
            'Ź':'Z', 'Ż':'Z',
            // latvian
            'ā':'a', 'č':'c', 'ē':'e', 'ģ':'g', 'ī':'i', 'ķ':'k', 'ļ':'l', 'ņ':'n',
            'š':'s', 'ū':'u', 'ž':'z', 'Ā':'A', 'Č':'C', 'Ē':'E', 'Ģ':'G', 'Ī':'i',
            'Ķ':'k', 'Ļ':'L', 'Ņ':'N', 'Š':'S', 'Ū':'u', 'Ž':'Z',
            // currency
            '€': 'euro', '₢': 'cruzeiro', '₣': 'french franc', '£': 'pound',
            '₤': 'lira', '₥': 'mill', '₦': 'naira', '₧': 'peseta', '₨': 'rupee',
            '₩': 'won', '₪': 'new shequel', '₫': 'dong', '₭': 'kip', '₮': 'tugrik',
            '₯': 'drachma', '₰': 'penny', '₱': 'peso', '₲': 'guarani', '₳': 'austral',
            '₴': 'hryvnia', '₵': 'cedi', '¢': 'cent', '¥': 'yen', '元': 'yuan',
            '円': 'yen', '﷼': 'rial', '₠': 'ecu', '¤': 'currency', '฿': 'baht',
            "$": 'dollar',
            // symbols
            '©':'(c)', 'œ': 'oe', 'Œ': 'OE', '∑': 'sum', '®': '(r)', '†': '+',
            '“': '"', '”': '"', '‘': "'", '’': "'", '∂': 'd', 'ƒ': 'f', '™': 'tm',
            '℠': 'sm', '…': '...', '˚': 'o', 'º': 'o', 'ª': 'a', '•': '*',
            '∆': 'delta', '∞': 'infinity', '♥': 'love', '&': 'and', '|': 'or',
            '<': 'less', '>': 'greater'
        };

        replacement = replacement || '-';
        var result = '';
        for (var i=0; i < string.length; i++) {
          var ch = string[i];
          if (charMap[ch]) {
            ch = charMap[ch];
          }
          ch = ch.replace(/[^\w\s$\*\_\+~\.\(\)\'\"\!\-:@]/g, ''); // allowed
          result += ch;
        }
        result = result.replace(/^\s+|\s+$/g, ''); // trim leading/trailing spaces
        result = result.replace(/[-\s]+/g, replacement); // convert spaces
        result.replace("#{replacement}$", ''); // remove trailing separator
        return result;
    }
});
