# -*- coding: utf-8 -*-

from .development import *

PORT = 8020

import os
import paramiko
import struct
import requests
from base64 import urlsafe_b64encode
from time import time


class OAuthError(Exception):
    pass


def extract_sign(signature_string):
    parts = []
    while signature_string:
        len = struct.unpack('>I', signature_string[:4])[0]
        bits = signature_string[4:len+4]
        parts.append(bits)
        signature_string = signature_string[len+4:]

    return parts[1]


def get_token(client_id, client_secret, login):
    """Получить токен для пользователя, используя
       SSH ключи из ssh-agent.
    """
    ts = int(time())
    string_to_sign = '%s%s%s' % (ts, client_id, login)
    ssh_keys = paramiko.Agent().get_keys()
    if not ssh_keys:
        raise OAuthError('no ssh keys or ssh-agent not running')
    for private_key in ssh_keys:
        sign = extract_sign(private_key.sign_ssh_data(string_to_sign))
        # TODO: добавить ретраи
        resp = requests.post(
            'https://oauth.yandex-team.ru/token',
            data={
                'grant_type': 'ssh_key',
                'client_id': client_id,
                'client_secret': client_secret,
                'login': login,
                'ts': ts,
                'ssh_sign': urlsafe_b64encode(sign),
            },
        )
        if resp.status_code < 500:
            rv = resp.json()
            if rv.get('error'):
                if rv['error'] == 'invalid_grant':
                    continue  # пробуем следующий ssh-ключ
                else:
                    raise OAuthError(rv.get('error_description', rv['error']))
            else:
                return rv['access_token']

    raise OAuthError('ssh_sign is not valid')


# Для запуска в Докере чуток отличаются параметры соединения с базой
if os.environ.get('DOCKER'):
    # main database settings
    MAIN_DB_SHARDS = ['database']
    MAIN_DB_DEFAULTS['host'] = 'main'
    MAIN_DB_DEFAULTS['port'] = 5432
    MAIN_DB_DEFAULTS['user'] = 'ydir'
    del MAIN_DB_DEFAULTS['password']

    # meta database settings
    META_DB_DEFAULTS = {
        'name': 'database',
        'host': 'meta',
        'port': 5432,
        'user': 'ydir',
    }
elif os.environ.get('ARCADIA'):
    user = os.environ.get('PG_LOCAL_USER')
    password = os.environ.get('PG_LOCAL_PASSWORD')
    db_name = os.environ.get('PG_LOCAL_DATABASE', '')
    port = os.environ.get('PG_LOCAL_PORT')

    #MAIN_DB_SHARDS = ['%s_autotests' % CURRENT_USER.replace('-', '_')]
    MAIN_DB_SHARDS = ['ydir_main']
    MAIN_DB_DEFAULTS = {
        'name': 'ydir_main',
        'host': 'localhost',
        'port': port,
        'user': user,
        'password': password,
    }
    # meta database settings
    META_DB_DEFAULTS = {
        'name': 'ydir_meta',
        'host': 'localhost',
        'port': port,
        'user': user,
        'password': password,
    }
elif os.environ.get('PYCHARM_TEST_RUN'):
    MAIN_DB_SHARDS = ['ydir_main']
    MAIN_DB_DEFAULTS = {
        'name': 'ydir_main',
        'host': '127.0.0.1',
        'port': 5432,
        'user': 'ydir',
        'password': 'ydir',
    }
    # meta database settings
    META_DB_DEFAULTS = {
        'name': 'ydir_meta',
        'host': '127.0.0.1',
        'port': 5432,
        'user': 'ydir',
        'password': 'ydir',
    }

else:
    # main database settings
    MAIN_DB_SHARDS = ['%s_autotests' % CURRENT_USER.replace('-', '_')]
    MAIN_DB_DEFAULTS['user'] = 'ydir'
    MAIN_DB_DEFAULTS['password'] = 'ydir'

    # meta database settings
    META_DB_DEFAULTS = {
        'name': MAIN_DB_SHARDS[0] + '_meta',
        'host': '127.0.0.1',
        'port': 5432,
        'user': 'ydir',
        'password': 'ydir',
    }

VAR_DATA_DIR_NAME = '%s_autotests' % CURRENT_USER.replace('-', '_')


INTERNAL_SERVICES.append({
    'name': 'Autotest',
    'identity': 'autotest',
    'tokens': ['12345'],
    # по умолчанию, автотестовый сервис обладает всеми скоупами
    'scopes': ['*'],
})

CONDUCTOR_CLIENT_CLASS = 'intranet.yandex_directory.src.yandex_directory.common.conductor.mock_client.ConductorMockClient'

AUTOTEST_NOTIFICATION_URL = 'http://localhost:' + str(PORT) + '/testnotify/'

AUTOTEST_CALLBACK = {
    'callback': AUTOTEST_NOTIFICATION_URL,
}

AUTOTEST_CALLBACK_FILTER = {
    'filter':  {'service': 'autotest'},
    'callback': AUTOTEST_NOTIFICATION_URL,
}

SOME_404 = {
    'callback': 'http:yandex.ru/not_exist/',
}

EDIT_PASSPORT_ACCOUNT = {
    'callback': 'intranet.yandex_directory.src.yandex_directory.passport.callbacks.edit_passport_account',
}

SUBSCRIPTIONS = dict()

# Подписка на события пользователей (наименование событий - в прошедшем времени)
SUBSCRIPTIONS['user_property_changed'] = [EDIT_PASSPORT_ACCOUNT]

SUBSCRIPTIONS['user_added'] = [
    {'callback': 'intranet.yandex_directory.src.yandex_directory.disk.callbacks.activate_user'}
]

TESTING = True
DB_LOGLEVEL = 'ERROR'

# для автотестов мы в диск не ходим
DISK_BASE_URL = None

DOMAIN_PART = '.ws.autotest.yandex.ru'

# Email
# для автотестов мы письма не шлем
MAIL_SEND_FUNCTION = 'intranet.yandex_directory.src.yandex_directory.core.mailer.mailer.dummy_send'


BLACKBOX_URL = 'http://pass-test.yandex.ru/blackbox'

# для тестов ограничим возможные варианты
ORGANIZATION_LANGUAGES = "ru,en"
PORTAL_TLDS = "ru,com"
DEFAULT_TLD = "ru"


SENDER_BASE_URL = ''
SENDER_CAMPAIGN_SLUG_WELCOME_EMAIL = 'SENDER_CAMPAIGN_SLUG_WELCOME_EMAIL'

# в тестах не шлём смс
YASMS_BASE_URL = ''
SMS_SEND_FUNCTION = 'intranet.yandex_directory.src.yandex_directory.core.sms.sms.dummy_send_sms'

BILLING_CLIENT_CLASS = 'intranet.yandex_directory.src.yandex_directory.common.billing.mock_client.MockBillingClient'

YT_ANALYTICS_TABLES_PATH = '//tmp/yandex-connect-autotests/tests/'
DIR_AUTOTESTS_OAUTH_CLIENT_ID = '2acfc414900e4dfa90a4c23abecd2ddd'
DIR_AUTOTESTS_OAUTH_SECRET = '608cc6c75a3547c2a101179b8dbbc1a6'

# Получим токен в обмен на ssh ключ.
# Чтобы это работало, нужно чтобы был настроен ssh_agent
YT_TOKEN = os.environ.get('YT_TOKEN')
BILLING_YT_TOKEN = YT_TOKEN

# Во время тестов не надо запускать пинговалку коннектов, потому что она
# съедает CPU и тесты бегут на треть дольше
PING_DB_CONNECTIONS_INTERVAL = 0

PROMOCODE_FOR_EDUCATION_ORG = 'edu_org_promocode'
PROMOCODE_FOR_YANDEX_PROJECT_ORG = 'yndx_org_promocode'

COMMON_METRIC_CALC_ENABLED = True

SCHEDULER_MODE = True

MIGRATE_DEPUTY_ADMINS = True

SHARDS_FOR_PORTAL = [4]

WEIGHT_COEF_FOR_SHARDS = 100000

# Это нам нужно, чтобы в автотестах мы не пытались достать из TVM
# все публичные ключи.
TVM_CLIENT_ID = None
TEAM_TVM_CLIENT_ID = None


REGISTRAR_GEN_TOKEN_SECRET = '$ecret' + 10 * '0'
REGISTRAR_STORE_TOKEN_SECRET = '$ecret' + 10 * '0'
REGISTRAR_STORE_PASSWORD_SECRET = 16 * '0'

SYNC_CLOUD_ORGS_TASK_CHUNK_SIZE = 10
SYNC_SSO_ORGS_TASK_CHUNK_SIZE = 3
