# -*- coding: utf-8 -*-
import os

from collections import defaultdict

minute = 60
hour = 60 * minute
day = 24 * hour

# На внутренних инстансах надо явно установить
# переменную окружения INTERNAL=True
INTERNAL = False

# окружения которые считаются production
# для них не светим подробности ошибки при 500
# и запрещаем  recreate таблиц при миграции
PRODUCTION_ENVIRONMENTS = ['production', 'external_prod', 'integration_qa', 'qa', 'qa1']

VIEW_CLASSES_WITHOUT_VERSION = ['PingView', 'StatsView', 'SimplePingView']

SITE_BASE_URI = 'http://dir.yd-dev.cmail.yandex.net/'

CURRENT_USER = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
PACKAGE_NAME = 'yandex-directory'
PROJECT_DIR = os.path.dirname(os.path.dirname(os.path.dirname(__file__)))

DATABASES_SSL_MODE = 'disable'
DATABASES_CONNECT_TIMEOUT = 1

ENABLE_ADMIN_API = False
DATABASE_POOL_SIZE = 5
DATABASE_MAX_OVERFLOW = 10
DATABASE_POOL_RECYCLE = 300

TEMPLATES_DIR = os.path.join(PROJECT_DIR, 'templates')

if os.environ.get('DOCKER'):
    INTERNAL_SERVICES_BY_TOKEN = True

    # тут нужно пробросить тунели до паспорта и абука, например так:
    # ssh -v -L 50080:passport-test-internal.yandex.ru:80 login@yd-dev.cmail.yandex.net

    PASSPORT_API = 'http://127.0.0.1:50080'
    TEAM_PASSPORT_API = 'http://127.0.0.1:50082'

    db_pass = 'nacc6opq'

    MAIN_DB_SHARDS = ['database']

    MAIN_DB_DEFAULTS = {
        'host': ['pgaas-main'],
        'port': 12000,
        'user': 'ydir',
        'password': db_pass
    }
    META_DB_DEFAULTS = {
        'name': 'database',
        'host': ['pgaas-meta'],
        'port': 12000,
        'user': 'ydir',
        'password': db_pass
    }

else:
    PASSPORT_API = 'http://passport-test-internal.yandex.ru/'

    db_pass = 'ydir'

    MAIN_DB_SHARDS = [CURRENT_USER.replace('-', '_')]

    MAIN_DB_DEFAULTS = {
        'host': '127.0.0.1',
        'port': 5432,
        'user': 'ydir',
        'password': db_pass,
    }
    META_DB_DEFAULTS = {
        'name': 'meta_%s' % CURRENT_USER.replace('-', '_'),
        'host': [{'host': '127.0.0.1', 'dc': 'myt'}],
        'port': 5432,
        'user': 'ydir',
        'password': db_pass,
    }

MIGRATE_DATABASE_USER = MAIN_DB_DEFAULTS['user']
MIGRATE_DBS = ['main', 'meta']

VAR_DATA_BASE_DIR_PATH = '/var/lib/yandex/yandex-directory/'
VAR_DATA_DIR_NAME = CURRENT_USER.replace('-', '_')

BLACKBOX_URL = 'http://blackbox-mimino.yandex.net/blackbox'
TEAM_BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'
PASSPORT_URL_LANDING = 'https://passport-test.yandex.ru/registration/connect'

CONDUCTOR_URL = 'https://c.yandex-team.ru/api-cached/'

YANDEX_TEAM_ORG_DOMAINS = ['yandex-team.ru', 'yandex.ru']

WMI_URL = 'http://web-tst1j.yandex.ru:9090/folders?uid=%s'

CONDUCTOR_CLIENT_CLASS = 'intranet.yandex_directory.src.yandex_directory.common.conductor.client.ConductorClient'

# токен можно сгенерить примерно так:
# import hashlib, time
# hashlib.sha1(str(time.time())).hexdigest()

INTERNAL_SERVICES = [
    {
        'name': 'Yamb',
        'identity': 'yamb',
        'scopes': ['*'],
    },
    {
        'name': 'Yandex.Disk',
        'identity': 'disk',
        'scopes': ['*'],
    },
    {
        'name': 'Portal',
        'identity': 'portal',
        'scopes': ['*'],
    },
    {
        'name': 'Documentation',
        'identity': 'swagger',
        'scopes': ['*'],
    },
    {
        'name': 'Command line client',
        'identity': 'cli-client',
        'scopes': ['*'],
    },
    {
        'name': 'Address book',
        'identity': 'abook',
        'scopes': ['*'],
    },
    {
        'name': 'Promo',
        'identity': 'promo',
        'scopes': ['*'],
    },
    {
        'name': 'YambBotPlatform',
        'identity': 'yamb-bot-platform',
        'scopes': ['*'],
    },
    {
        'name': 'Corporate ML',
        'identity': 'corp-maillist',
        'scopes': ['*'],
    },
    {
        'name': 'Wiki',
        'identity': 'wiki',
        'scopes': ['*'],
    },
    {
        'name': 'Passport',
        'identity': 'passport',
        'scopes': ['*'],
    },
    {
        'name': 'StaffLight',
        'identity': 'staff-light',
        'scopes': ['*'],
    },
    {
        'name': 'Startrek',
        'identity': 'startrek',
        'scopes': ['*'],
    },
    {
        'name': 'Mail frontend',
        'identity': 'mail-frontend',
        'scopes': ['*'],
    },
    {
        'name': 'Integration tests',
        'identity': 'integration-test',
        'scopes': ['integration_tests_send_emails'],
    },
    {
        'name': 'Sales portal',
        'identity': 'sales-portal',
        'scopes': ['directory:read_organization', 'work_with_any_organization', 'work_on_behalf_of_any_user'],
    },
]

DB_LOG_LEVEL = 'WARNING'  # может быть 'INFO' или 'DEBUG', если надо выводить параметры
LOG_LEVEL = 'DEBUG'

SUBSCRIPTIONS = defaultdict(list)

SUBSCRIPTIONS['user_added'].extend([
    {'callback': 'intranet.yandex_directory.src.yandex_directory.disk.callbacks.activate_user'}
])

TESTING = False
YANDEX_ALL_CA = os.path.join(
    os.path.dirname(os.path.dirname(os.path.dirname(__file__))),
    'ssl/yandexAllCAs.pem'
)

STAFF_API_URL = 'https://staff-api.test.yandex-team.ru/v3/'

# Yandex Disk
# тестовое окружение
DISK_BASE_URL = 'https://mpfs-stable.dst.yandex.net/json/'
DISK_NO_EMAIL = True

X_DEBUG = False

# Jobs
EVENTS_LOG_SIZE_DAYS = 180

DOMAIN_PART = '.yaconnect.com'

# Email
MAIL_SEND_FUNCTION = 'intranet.yandex_directory.src.yandex_directory.core.mailer.mailer.dummy_send'
MAIL_SEND_DELAY = 30

GOLOVAN_STATS_AGGREGATOR_CLASS = 'golovan_stats_aggregator.MemoryStatsAggregator'
# Собирать статистику для голована будем раз 10
GOLOVAN_STATS_AGGREGATOR_PERIOD = 10
# таймаут на выполнение функций, собирающих метрики для голована
# установим в 10 секунд, чтобы уж точно уложиться между двумя запусками сбора статистики
GOLOVAN_STATS_AGGREGATOR_FUNCTION_TIMEOUT = 10

# отправляем в голован количество доменов, которые заблокированны дольше определенного времени
MONITOR_BLOCKED_DOMAINS_LONGER_THAN_MIN = 10

# время жизни кода приглашения в часах
INVITES_HOURS_LIFETIME = 24

SYNC_WITH_STAFF_ENABLED = 0

# записываем в лог долгие запросы к базе
LOG_SLOW_SQL_QUERIES = True
PING_DB_CONNECTIONS_INTERVAL = 15  # сек

# TTL для кэша подписок на события
WEBHOOKS_CACHE_TTL = 300  # сек
# Размер кэша подписок на события (в байтах)
WEBHOOKS_CACHE_SIZE = 1024 * 1024

# возможнные языки в организации
ORGANIZATION_LANGUAGES = "ru,en"

# на каких tld доменах работает портал
PORTAL_TLDS = "ru,com"
DEFAULT_TLD = "ru"

PORTAL_URL_TEMPLATE = 'https://connect-test.ws.yandex.{tld}/'

OAUTH_BASE_URL = 'https://oauth-test.yandex.ru/'

# Этот урл используется только для TVM 1.0
TVM_URL = 'https://tvm-api-test.yandex.net'
BLACKBOX_TVM_CLIENT_ID = 224  # тестовый BLACKBOX
TEAM_BLACKBOX_TVM_CLIENT_ID = 223  # team BLACKBOX
TEAM_TVM_CLIENT_ID = 2000983
DISK_TVM_CLIENT_ID = 127
BIGML_TVM_CLIENT_ID = 2017269
FORMS_TVM_CLIENT_ID = 2001259
ZORA_TVM_CLIENT_ID = 2023123
METRIKA_TVM_CLIENT_ID = 2000269
DOMENATOR_TVM_CLIENT_ID = 2020711
YANDEXSPRAV_TVM_CLIENT_ID = 2011748
DIRECT_TVM_CLIENT_ID = 2000693
ALICE_B2B_TVM_CLIENT_ID = 2015561


# Это путь к файлу, в котором должны храниться OAuth секреты
# для получения роботных токенов
SERVICE_OAUTH_DATA_FILE = '/etc/yandex/oauth'

# закрывать сервис от балансера отдачей 503 ошибок после
# определенного количества ошибок (BACKPRESSURE_CLOSE_AFTER_ERRORS_COUNT) в жизненно-важных подсистемах в смоук-тестах
# за определенное количество попыток (BACKPRESSURE_CHECK_WINDOW_SIZE)
BACKPRESSURE_CLOSE_AFTER_ERRORS_COUNT = 5
BACKPRESSURE_CHECK_WINDOW_SIZE = 5

BILLING_API_URL = 'https://balance-xmlrpc-tvm-ts.paysys.yandex.net:8004/xmlrpctvm'
BILLING_TVM2_CLIENT_ID = 2000601
BILLING_API_TOKEN = ''
# это uid менеджера который будет получать разные оповещения от Биллинга о клиентах
# в продакшене это будет специальная рассылка
BILLING_MANAGER_UID = 610273355
BILLING_YT_TABLES_PATH = '//tmp/yandex-connect/dev/billing/'
BILLING_YT_TOKEN = None
BILLING_YT_CLUSTERS = 'hahn,arnold'
BILLING_SAVING_ENABLED = False
BILLING_CLIENT_CLASS = 'intranet.yandex_directory.src.yandex_directory.common.billing.client.BillingClient'
BILLING_CLIENT_UID_FOR_TESTING = None
BILLING_PRODUCT_ID_RUB = 508529  # для оплаты
BILLING_INVOICE_API_URL = 'https://user-balance.greed-ts.paysys.yandex.ru/'
BILLING_INVOICE_API_TVM2_CLIENT_ID = 2001900

BILLING_CONNECT_PRODUCT_ID = 508507
BILLING_CONNECT_ONE_PRODUCT_ID = 508546
BILLING_CONNECT_TWO_PRODUCT_ID = 508547
BILLING_CONNECT_ONE_PAID_PRODUCT_PRICE = 570
BILLING_CONNECT_TWO_PAID_PRODUCT_PRICE = 285


# пока нет сервисов с лицензиями для трекера забиваем настройки продуктов по количеству людей
BILLING_TRACKER_TEN_PRODUCT_ID = 508509
BILLING_TRACKER_HUNDRED_PRODUCT_ID = 508510
BILLING_TRACKER_FIVE_HUNDRED_PRODUCT_ID = 508511
BILLING_TRACKER_TWO_THOUSAND_PRODUCT_ID = 508512
BILLING_PAYMENT_TERM = 30

BILLING_PARTNER_DISK_PRODUCT_ID = 510982

# настройки для складывания данных в yt
YT_CLUSTER = 'hahn'
YT_TOKEN = None

# общие настройки походов в YT
# работают и для биллинговых YT клиентов и для оставльных
YT_CONNECT_TIMEOUT = 1000  # миллисекунды
YT_REQUEST_TIMEOUT = 20000  # миллисекунды

YT_ANALYTICS_TABLES_PATH = '//tmp/yandex-connect/testing/analytics/'
YT_ANALYTICS_SECOND_TABLES_PATH = '//tmp/yandex-connect/testing/analytics2/'
YT_ANALYTICS_SAVING_ENABLED = False

# частота опроса задач воркеров при разгребании очереди
TASK_POLLING_INTERVAL = 1
TASK_POLLING_MAX_INTERVAL = 30

# параметры для рассылятора
SENDER_ACCOUNT_SLUG = 'ya.connect'
SENDER_USER = 'ce2cfe4579e9437eb0061867b13d5583'
SENDER_BASE_URL = 'https://test.sender.yandex-team.ru/'
SENDER_CAMPAIGN_SLUG_WELCOME_EMAIL = '02EL3SF2-LOE'
SENDER_CAMPAIGN_SLUG_AFTER_CREATE_ORGANIZATION_EMAIL = '8C1M80H2-LIM1'
SENDER_CAMPAIGN_SLUG_TRACKER_ACTIVATED_EMAIL = '0QLQ34I2-MK91'
SENDER_CAMPAIGN_SLUG_TRACKER_SUBSCRIPTION_ACTIVATED_EMAIL = '4DU44WQ2-URK'
SENDER_CAMPAIGN_SLUG_TRACKER_DISABLE_NOTIFICATION_1 = 'KXKROLM3-RTO'
SENDER_CAMPAIGN_SLUG_TRACKER_DISABLE_NOTIFICATION_2 = 'SZJJSLM3-1802'
SENDER_CAMPAIGN_SLUG_TRACKER_DISABLE_NOTIFICATION_3 = '82DBULM3-NDW1'
SENDER_CAMPAIGN_SLUG_PAID_MODE_ENABLE_EMAIL = ''
SENDER_CAMPAIGN_SLUG_14_DAYS_DEBT_EMAIL = '14days'
SENDER_CAMPAIGN_SLUG_21_DAYS_DEBT_EMAIL = '21days'
SENDER_CAMPAIGN_SLUG_28_DAYS_DEBT_EMAIL = '28days'
SENDER_CAMPAIGN_SLUG_29_DAYS_DEBT_EMAIL = '29days'
SENDER_CAMPAIGN_SLUG_30_DAYS_EMAIL = '30days'
SENDER_CAMPAIGN_SLUG_31_DAYS_EMAIL = '31days'
SENDER_CAMPAIGN_SLUG_CHANGE_PASSWORD_EMAIL = 'GAZ0I7W2-0QH1'
SENDER_CAMPAIGN_SLUG_DISABLE_DOMAIN_EMAIL = '4NJ54KX2-Q0J'
SENDER_CAMPAIGN_SLUG_INVITE_USER = 'GCK5M113-JC5'
SENDER_CAMPAIGN_SLUG_ACCESS_RESTORE_TRY_RESTORE = '02QI1143-4RI'
SENDER_CAMPAIGN_SLUG_ACCESS_RESTORE_SOME_RESTORE = '4NEB0143-IQ51'
SENDER_CAMPAIGN_SLUG_ACCESS_RESTORE_SUCCESS_RESTORE = 'KBFEX043-AFY1'
SENDER_CAMPAIGN_SLUG_REQUEST_ACCESS_TO_RESOURCE = ''
# todo: заполнить когда появятся письма на запрос получения доступа к ресурсу
SENDER_CAMPAIGN_SLUG_CONFIRM_ACCESS_TO_RESOURCE = ''
# todo: заполнить когда появятся письма на подтверждение доступа к ресурсу
SENDER_CAMPAIGN_SLUG_DENY_ACCESS_TO_RESOURCE = ''
# todo: заполнить когда появятся письма на отказ доступа к ресурсу
SENDER_CAMPAIGN_METRIKA_RESOURCE_UNBIND = 'O8B39SE3-LT3'

CLOUD_NOTIFY_URL = ''

# парметры для рассылки sms
YASMS_BASE_URL = 'http://phone-passport-test.yandex.ru'
YASMS_SENDER = 'directory'
SMS_SEND_FUNCTION = 'intranet.yandex_directory.src.yandex_directory.core.sms.sms.dummy_send_sms'
SMS_NOTIFY_TRACKER_HOLD_TIME = 5 * 60  # 5 минут

PER_HUMAN_DISK_LIMIT = 100 * 1024 * 1024 * 1024
TEN_HUMAN_DISK_LIMIT = 1024 * 1024 * 1024 * 1024  # 1TiB

# id организаций доступных для yamb-test, разделённые запятой
YAMB_TEST_ORGANIZATIONS = ''

# Данные для аватарницы, в которой лежат лого организаций.
MDS_READ_API = 'https://avatars.mds.yandex.net'
MDS_WRITE_API = 'http://avatars-int.mds.yandex.net:13000'
MDS_NAMESPACE = 'connect'

# Даные для работы с s3 api mds
MDS_S3_API_URL = 'https://s3.mdst.yandex.net'

ROBOT_ACCOUNT_NICKNAME_PREFIX = 'robot-'

# поддерживаемые версии API
SUPPORTED_API_VERSIONS = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]

STAFF_YANDEX_TEAM_URL = 'https://staff.yandex-team.ru/'
STAFF_URL = 'https://staff.yandex.{tld}/'
STAFF_TOKEN = None

PLAYGROUND_OAUTH_CONFIG = {
    'api-internal-test.directory.ws.yandex.net': {
        'client_id': 'a608cdde133747b18062393483891221',
        'oauth_host': 'oauth-test.yandex.ru'
    },
    'api-internal-qa.directory.ws.yandex.net': {
        'client_id': 'fba892da4ec44b4f9d8884b17eadc3c3',
        'oauth_host': 'oauth.yandex.ru'
    },
    'api-internal.directory.ws.yandex.net': {
        'client_id': '192e2a850f7e4bf9a0104cfb73159e93',
        'oauth_host': 'oauth.yandex.ru'
    },
}
other_qa_hosts = [
    'api-qa1.directory.ws.yandex.net',
    'api-qa2.directory.ws.yandex.net',
    'api-qa3.directory.ws.yandex.net',
]
for host in other_qa_hosts:
    PLAYGROUND_OAUTH_CONFIG[host] = PLAYGROUND_OAUTH_CONFIG['api-internal-qa.directory.ws.yandex.net']

TRACKER_7_DAYS_BEFORE_TRIAL_END_MAIL_ID = 'OYIHCSZ2-3RY1'
TRACKER_3_DAYS_BEFORE_TRIAL_END_MAIL_ID = '8QRSF3Q2-ZB8'
TRACKER_1_DAYS_BEFORE_TRIAL_END_MAIL_ID = 'CNB7G3Q2-3JE1'

WEBMASTER_URL = 'https://webmaster3-internal.test.in.yandex.net'
WEBMASTER_CLIENT_ID = 2000286

LOCK_DNS_DELEGATION_DURATION = 2 * day

CACHE_ENABLED = False
REDIS_HOST = None
REDIS_PASSWORD = None

# Определяем ДЦ из переменной окруженя QLOUD_DATACENTER, либо определяем как ДЦ
# используемый в consul по умолчанию
CACHE_DATACENTER = os.environ.get('DEPLOY_NODE_DC', os.environ.get('QLOUD_DATACENTER', 'dc1')).lower()

PER_PAGE_DEFAULT = 20
PER_PAGE_MAX = 100
PER_PAGE_MAX_FOR_ADMIN = 100

READ_ONLY_MODE = False

YARM_URL = 'http://yarm.mail.yandex.net:3048/'
YANDEX_MAIL_SERVERS = [
    'imap.yandex.ru',
    'pop.yandex.ru',
    'imap.yandex.com',
    'pop.yandex.com',
]

STEP_API = 'https://step-sandbox1.n.yandex-team.ru'
STEP_TOKEN = ''

# включение на компоненте подсчета общих для окружения показателей
COMMON_METRIC_CALC_ENABLED = False

# сколько ждем зарастания дыр событий при оповещении подписчиков (сек)
EVENT_HOLE_WAIT_TTL = 10

IDM_API = 'https://idm-api.yandex-team.ru:443/'
IDM_CACHE_TTL = 60 * 15
CONNECT_ADMIN_SLUG = 'connect-admin-test'

SCHEDULER_MODE = False

DEFAULT_QUEUE_NAME = 'default'

NOTIFY_BATCH_SIZE = 1000
NOTIFY_THREAD_POOL_SIZE = 10

MIGRATE_DEPUTY_ADMINS = False

BIGML_API = 'https://test.beagle.mail.yandex.net'

SETTINGS_WS_URL = 'https://settings-test.ws.yandex.ru/connect'
SETTINGS_WS_TOKEN = ''

# Указанные здесь шарды будут использоваться только для организаций с типом 'portal'.
# Нумерация шардов начинается с 1.
# DIR-5335
SHARDS_FOR_PORTAL = []

WEIGHT_COEF_FOR_SHARDS = 100000

SECRET_PLACEHOLDER = '************'
SENSITIVE_KEYS = [
    'password',
    'x-ya-service-ticket',
    'x-ya-user-ticket',
    'ticket',
    'authorization',
    'cookie',
    'invite_link',
]

DEFAULT_INVITE_LIMIT = 10000

# количество пользователей в организации для критерия VIP (many_users)
VIP_MANY_USERS_COUNT = 100

SHARDS_WITH_WEIGHT_CACHE_TTL = 60 * 15

ORG_LIMIT_USER_ALIASES_MAX_COUNT = 10
ORG_LIMIT_USERS_LIMIT = 1000

FORMS_HOST = 'https://forms-biz-api.test.yandex.ru'
ZORA_HOST = 'http://connect:{tvm}@go.zora.yandex.net:1080'
DOMENATOR_HOST = 'https://domenator-test.yandex.net'
METRIKA_HOST = 'https://internalapi.test.metrika.yandex.net'
YANDEXSPRAV_HOST = 'http://sprav-api-test.yandex.net'
DIRECT_HOST = 'https://test-direct.yandex.ru:9443'
ALICE_B2B_HOST = 'https://dialogs.priemka.voicetech.yandex.net'
BIND_ACCESS_SKIP_CHECK = {
    'tools-integration-test',
    'alice_b2b',
}

CHECK_RESOURCE_EXISTENCE_ENABLED = False
USER_ORGANIZATIONS_LIMIT = 500

CLOUD_HOST = 'rm.private-api.cloud-preprod.yandex.net:4284'
CLOUD_ORG_HOST = 'org.private-api.cloud-preprod.yandex.net:4290'
CLOUD_IAM_HOST = 'https://iam.api.cloud-preprod.yandex.net/iam/'
CLOUD_SESSION_SERVICE_HOST = 'ss.private-api.cloud-preprod.yandex.net:8655'
# token service
CLOUD_TS_HOST = 'ts.private-api.cloud-preprod.yandex.net:4282'
CLOUD_KEY = 'bfb7prfatup7ugu71n87'
CLOUD_SERVICE_ACCOUNT_ID = 'bfbeo8vvta9heu35a1b4'
CLOUD_ACCESS_SERVICE_HOST = ''
CLOUD_TRACKER_ID_PREFIX = 'aat'

TRACKER_YT_ORGANIZATIONS_TABLE = ''

BLACK_DOMAINS_LIST = [
    'yandex.info',
]

REDIS_SOCKET_TIMEOUT = 0.2

