# -*- coding: utf-8 -*-

import os
from .base import *

PORT = 1

SITE_BASE_URI = 'https://api.directory.yandex.ru/'

# main database settings
MAIN_DB_SHARDS = [
    {
        'name': 'dirdb',
        'host': [
            {'host': 'dirdb01h.db.yandex.net', 'dc': 'sas'},
            'man-8cl3kdpagamujxrh.db.yandex.net',
            'vla-ydgq8udokfb9xdyo.db.yandex.net',
        ],
    },
    {
        'name': 'dirdb02',
        'host': [
            'man-8wytt6txrc45ldmj.db.yandex.net',
            'sas-4hkkkpe6pr9jl4db.db.yandex.net',
            'vla-gomh4o0o0rhid7r4.db.yandex.net',
        ],
    },
    {
        'name': 'dirdb03',
        'host': [
            'man-3758pr8p48yzflk1.db.yandex.net',
            'sas-pdcdkv7ejjkmf8xu.db.yandex.net',
            'vla-vag6kzf9kjab445d.db.yandex.net',
        ],
    },
    {
        'name': 'dirdb04',
        'host': [
            'man-f4tao5glbmo88qyy.db.yandex.net',
            'sas-t810zd2n0bgur524.db.yandex.net',
            'vla-bf214gk9y6i4xbkh.db.yandex.net',
        ],
    },
    {
        'name': 'dirdb05',
        'host': [
            'man-paxg3ahtomogci09.db.yandex.net',
            'sas-zgnj08vzkaears1j.db.yandex.net',
            'vla-mb1x0h28e6ud7knq.db.yandex.net',
        ],
    },
]
# нумерация шардов начинается с 1
SHARDS_FOR_PORTAL = [4]

WEIGHT_COEF_FOR_SHARDS = 100000
DATABASES_SSL_MODE = 'verify-full'

MAIN_DB_DEFAULTS = {
    'port': 6432,
    'user': 'ydir',
}

META_DB_DEFAULTS = {
    'name': 'meta_dirdb01',
    'host': [
        'myt-6q4p654n94ozs7jb.db.yandex.net',
        'sas-3k9r4hupyfkpvkr5.db.yandex.net',
        'vla-q5ulkf4sf8t3s8rf.db.yandex.net',
    ],
    'port': 6432,
    'user': 'ydir',
}

MIGRATE_DATABASE_USER = 'ydir'

VAR_DATA_DIR_NAME = 'production'

YANDEX_ALL_CA = '/root/app/ssl/yandexAllCAs.pem'

BLACKBOX_URL = 'http://blackbox-ipv6.yandex.net/blackbox'

WMI_URL = 'http://meta.mail.yandex.net:9090/folders?uid=%s'

TEST_NOTIFICATION_URL = 'http://localhost/testnotify/'
PASSPORT_URL_LANDING = 'https://passport.yandex.ru/registration/connect'
PASSPORT_API = 'http://passport-internal.yandex.ru/'

TEST_CALLBACK = {
    'callback': TEST_NOTIFICATION_URL,
}

TEST_CALLBACK_FILTER = {
    'filter': {'service': 'yamb'},
    'callback': TEST_NOTIFICATION_URL,
}

EDIT_PASSPORT_ACCOUNT = {
    'callback': 'intranet.yandex_directory.src.yandex_directory.passport.callbacks.edit_passport_account',
}

SUBSCRIPTIONS['user_property_changed'].extend([
    EDIT_PASSPORT_ACCOUNT,
])

STAFF_API_URL = 'https://staff-api.yandex-team.ru/v3/'

TEMPLATES_DIR = '/var/www/yandex/yandex-directory/templates'

# Yandex.Disk
# Продакшн окружение
DISK_BASE_URL = 'https://mpfs.disk.yandex.net/json/'

DOMAIN_PART = '.yaconnect.com'

# Email
MAIL_SEND_FUNCTION = 'intranet.yandex_directory.src.yandex_directory.core.mailer.mailer.send'

GOLOVAN_STATS_AGGREGATOR_CLASS = 'golovan_stats_aggregator.uwsgi.UwsgiStatsAggregator'

SYNC_WITH_STAFF_ENABLED = 1

PORTAL_URL_TEMPLATE = 'https://connect.yandex.{tld}/'

OAUTH_BASE_URL = 'https://oauth.yandex.ru/'

TVM_URL = 'https://tvm-api.yandex.net'
BLACKBOX_TVM_CLIENT_ID = 222
TEAM_TVM_CLIENT_ID = 2000985
BIGML_TVM_CLIENT_ID = 2016773
FORMS_TVM_CLIENT_ID = 2000105
METRIKA_TVM_CLIENT_ID = 2000270
DOMENATOR_TVM_CLIENT_ID = 2020709
DIRECTORY_TVM_CLIENT_ID = 2000205

# параметры для рассылятора
SENDER_BASE_URL = 'https://sender.yandex-team.ru'
SENDER_USER = '4325b21ee8704c6092eb931f7f2cce99'
SENDER_CAMPAIGN_SLUG_AFTER_CREATE_ORGANIZATION_EMAIL = '4BWN7ZG2-SCM'
SENDER_CAMPAIGN_SLUG_WELCOME_EMAIL = '0KR5HFE2-AX4'
SENDER_CAMPAIGN_SLUG_TRACKER_ACTIVATED_EMAIL = '4DU44WQ2-URK'
SENDER_CAMPAIGN_SLUG_WIKI_ACTIVATED_EMAIL = 'GE0RQIM2-M5E'
SENDER_CAMPAIGN_SLUG_PAID_MODE_ENABLE_EMAIL = '0W8DERJ2-ORR'
SENDER_CAMPAIGN_SLUG_14_DAYS_DEBT_EMAIL = 'KF4YERJ2-TKD'
SENDER_CAMPAIGN_SLUG_21_DAYS_DEBT_EMAIL = 'CL90FRJ2-6X41'
SENDER_CAMPAIGN_SLUG_28_DAYS_DEBT_EMAIL = '0YC1FRJ2-HG31'
SENDER_CAMPAIGN_SLUG_29_DAYS_DEBT_EMAIL = '0494FRJ2-HOI1'
SENDER_CAMPAIGN_SLUG_30_DAYS_EMAIL = 'SBQ2FRJ2-JIR'
SENDER_CAMPAIGN_SLUG_31_DAYS_EMAIL = 'SJF5FRJ2-KTN1'
SENDER_CAMPAIGN_SLUG_INVITE_USER = 'O88H9013-PZO1'

CLOUD_NOTIFY_URL = 'https://console.cloud.yandex.net/notify/v1/send'

YASMS_BASE_URL = 'http://sms.passport.yandex.ru'
YASMS_SENDER = 'directory'
SMS_SEND_FUNCTION = 'intranet.yandex_directory.src.yandex_directory.core.sms.sms.send_sms'

# id организаций доступных для yamb-test, разделённые запятой
YAMB_TEST_ORGANIZATIONS = '278'

# Данные для аватарницы, в которой лежат лого организаций.
# Для чтения используем https потому что у нас все сервисы
# работают по https и урлы картинок тоже должны быть секьюрные.
MDS_READ_API = "https://avatars.mds.yandex.net"
MDS_WRITE_API = "http://avatars-int.mds.yandex.net:13000"
MDS_NAMESPACE = "connect"

# Даные для работы с s3 api mds
MDS_S3_API_URL = 'https://s3.mds.yandex.net'

BILLING_YT_TABLES_PATH = '//home/yandex-connect-billing/data'
BILLING_API_URL = 'https://balance-xmlrpc-tvm.paysys.yandex.net:8004/xmlrpctvm'
BILLING_TVM2_CLIENT_ID = 2000599
BILLING_YT_CLUSTERS = 'hahn,arnold'
BILLING_INVOICE_API_URL = 'https://balance.yandex.ru/'
BILLING_INVOICE_API_TVM2_CLIENT_ID = 2001902

WEBMASTER_URL = 'https://webmaster3-internal.prod.in.yandex.net'
WEBMASTER_CLIENT_ID = 2000036

STEP_API = 'https://step-sandbox.n.yandex-team.ru'

CONNECT_ADMIN_SLUG = 'connect-admin'

BIGML_API = 'https://beagle.mail.yandex.net'

SETTINGS_WS_URL = 'https://settings.ws.yandex.ru/connect'

FORMS_HOST = 'https://forms-biz-api.yandex.ru'
DOMENATOR_HOST = 'https://domenator.yandex.net'
METRIKA_HOST = 'https://internalapi.metrika.yandex.ru:8097'

GENDARME_URL = 'https://gendarme.mail.yandex.net'
GENDARME_TVM_CLIENT_ID = 2002834

FOURAS_HOST = 'https://fouras.mail.yandex.net'
FOURAS_TVM_CLIENT_ID = 2012036

SSO_CONFIG_HOST = 'https://federal-cfg-api.passport.yandex.net'
SSO_CONFIG_TVM_CLIENT_ID = 2032890

IDM_B2B_HOST = 'https://idm-api.yandex.ru'
IDM_B2B_TVM_CLIENT_ID = 2014580

YANDEXSPRAV_TVM_CLIENT_ID = 2011746
YANDEXSPRAV_HOST = 'https://sprav-api.yandex.net'

ALICE_B2B_TVM_CLIENT_ID = 2015561
ALICE_B2B_HOST = 'https://paskills.voicetech.yandex.net'

CHECK_RESOURCE_EXISTENCE_ENABLED = True

DIRECT_TVM_CLIENT_ID = 2000390
DIRECT_HOST = 'https://intapi.direct.yandex.ru'

CLOUD_HOST = 'rm.private-api.cloud.yandex.net:4284'
CLOUD_ORG_HOST = 'org.private-api.cloud.yandex.net:4290'
CLOUD_IAM_HOST = 'https://iam.api.cloud.yandex.net/iam/'
CLOUD_KEY = 'ajers7ti01jirskbu4er'
CLOUD_SERVICE_ACCOUNT_ID = 'ajehm1ml532vumlm043j'
CLOUD_ACCESS_SERVICE_HOST = 'as.private-api.cloud.yandex.net:4286'
CLOUD_SESSION_SERVICE_HOST = 'ss.private-api.cloud.yandex.net:8655'
# token service
CLOUD_TS_HOST = 'ts.private-api.cloud.yandex.net:4282'
CLOUD_TRACKER_ID_PREFIX = 'bpf'

PARTNER_DISK_HOST = 'https://intapi.disk.yandex.net:8443'
PARTNER_DISK_TVM_CLIENT_ID = 132

# Following https://st.yandex-team.ru/DISKBACK-140
CRON_CHECK_BALANCE = False

TRACKER_YT_ORGANIZATIONS_TABLE = '//home/startrek/tables/prod/b2b/all/organizations'

YA_TEAM_ORG_IDS = {34}

LOGBROKER_ENDPOINT = 'logbroker.yandex.net'
LOGBROKER_PORT = '2135'
LOGBROKER_TOPIC = 'domenator_logbroker/production/domenator-topic'
LOGBROKER_CONSUMER_NAME = 'domenator_logbroker/production/yandex_connect_consumer_production'
LOGBROKER_TVM_ID = 2001059
PASSPORT_LOGBROKER_TOPIC = "/passport/passport-account-modification-log-fast"
PASSPORT_LOGBROKER_CONSUMER_NAME = "/directory/passport/passport-account-modification-production"

REDIS_HOSTS = [
    'man-8o3wzuxhj2i7gvew.db.yandex.net',
    'sas-d0pnsdu4fwwr0tpx.db.yandex.net',
    'vla-fsh0v16bpolfvges.db.yandex.net',
]
REDIS_DB_NAME = 'redis_prod'
