#!/usr/bin/env python
# -*- coding: utf-8 -*-
import warnings
import os

if 'LOG_LEVEL' not in os.environ:
    os.environ['LOG_LEVEL'] = 'WARNING'

from flask_script import Manager
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.setup import setup_app

setup_app(app)
manager = Manager(app)


import sys
import importlib


def get_module_dir(module_string):
    module = importlib.import_module(module_string)
    return os.path.dirname(module.__file__)


COMMANDS_FILES = (
    'intranet.yandex_directory.src.yandex_directory.meta.commands.import_registrars',
    'intranet.yandex_directory.src.yandex_directory.commands.build_events_doc',

    'intranet.yandex_directory.src.yandex_directory.common.commands.api_errors',
    'intranet.yandex_directory.src.yandex_directory.common.commands.dbshell',
    'intranet.yandex_directory.src.yandex_directory.common.commands.generate_ammo',
    'intranet.yandex_directory.src.yandex_directory.common.commands.generate_ammo_portal',
    'intranet.yandex_directory.src.yandex_directory.common.commands.generate_requests_json',
    'intranet.yandex_directory.src.yandex_directory.common.commands.migrate_database',
    'intranet.yandex_directory.src.yandex_directory.common.commands.runserver',
    'intranet.yandex_directory.src.yandex_directory.common.commands.shell',
    'intranet.yandex_directory.src.yandex_directory.common.commands.smoke_test',

    'intranet.yandex_directory.src.yandex_directory.core.commands.accept_eula_for_robots',
    'intranet.yandex_directory.src.yandex_directory.core.commands.analyze_query',
    'intranet.yandex_directory.src.yandex_directory.core.commands.change_org_admin',
    'intranet.yandex_directory.src.yandex_directory.core.commands.change_organization_type',
    'intranet.yandex_directory.src.yandex_directory.core.commands.check_balance_and_debt',
    'intranet.yandex_directory.src.yandex_directory.core.commands.check_inactive_contracts',
    'intranet.yandex_directory.src.yandex_directory.core.commands.check_user_disk',
    'intranet.yandex_directory.src.yandex_directory.core.commands.copy_org_schema',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_fake_organizations',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_group_resources',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_head_groups',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_org_domains',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_resources_for_tracker',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_robots',
    'intranet.yandex_directory.src.yandex_directory.core.commands.create_swagger_spec',
    'intranet.yandex_directory.src.yandex_directory.core.commands.disable_expired_promocodes',
    'intranet.yandex_directory.src.yandex_directory.core.commands.disable_service_trial_expired',
    'intranet.yandex_directory.src.yandex_directory.core.commands.enable_yaorg',
    'intranet.yandex_directory.src.yandex_directory.core.commands.excluded_shards',
    'intranet.yandex_directory.src.yandex_directory.core.commands.export_json_schemas',
    'intranet.yandex_directory.src.yandex_directory.core.commands.fill_fake_emails',
    'intranet.yandex_directory.src.yandex_directory.core.commands.get_external_org_ids',
    'intranet.yandex_directory.src.yandex_directory.core.commands.import_json',
    'intranet.yandex_directory.src.yandex_directory.core.commands.init_members_count',
    'intranet.yandex_directory.src.yandex_directory.core.commands.migrate_exists_org_admins',
    'intranet.yandex_directory.src.yandex_directory.core.commands.migrate_group_members_count',
    'intranet.yandex_directory.src.yandex_directory.core.commands.normalize_dismissed',
    'intranet.yandex_directory.src.yandex_directory.core.commands.normalize_org_names',
    'intranet.yandex_directory.src.yandex_directory.core.commands.notify_about_trial_expiration',
    'intranet.yandex_directory.src.yandex_directory.core.commands.passport_org',
    'intranet.yandex_directory.src.yandex_directory.core.commands.remove_dismissed_group_admins',
    'intranet.yandex_directory.src.yandex_directory.core.commands.save_analytics',
    'intranet.yandex_directory.src.yandex_directory.core.commands.save_analytics_to_yt',
    'intranet.yandex_directory.src.yandex_directory.core.commands.service_add',
    'intranet.yandex_directory.src.yandex_directory.core.commands.set_dismissed_in_metabase',
    'intranet.yandex_directory.src.yandex_directory.core.commands.set_external_org_ids',
    'intranet.yandex_directory.src.yandex_directory.core.commands.show_metrics',
    'intranet.yandex_directory.src.yandex_directory.core.commands.show_survey_for_automigrated_admins',
    'intranet.yandex_directory.src.yandex_directory.core.commands.task_types',
    'intranet.yandex_directory.src.yandex_directory.core.commands.update_maillist_uids',
    'intranet.yandex_directory.src.yandex_directory.core.commands.update_services_in_shards',
    'intranet.yandex_directory.src.yandex_directory.core.commands.update_vip_reasons',
)


ADDED_COMMANDS = {}

# загружаем команды из разных директорий
for command_file in COMMANDS_FILES:
    #sys.path.insert(0, commands_dir)

    module = importlib.import_module(command_file)

    if not hasattr(module, 'Command'):
        warnings.warn('Unable to find Command in {0}.'.format(
            command_file
        ))
        continue

    if not hasattr(module.Command, 'name'):
        warnings.warn('Command, defined in {0} has no "name" attribute.'.format(
            command_file
        ))
        continue

    command_name = module.Command.name
    if command_name in ADDED_COMMANDS:
        warnings.warn('Command "{0}", loaded from {1}, already defined in {2}.'.format(
            command_name,
            command_file,
            ADDED_COMMANDS[command_name],
        ))
        continue

    manager.add_command(
        command_name,
        module.Command(),
    )
    ADDED_COMMANDS[command_name] = command_file


def main():
    manager.run()


if __name__ == "__main__":
    main()
