class RangeDict(dict):
    # https://stackoverflow.com/a/39358140/4227169
    def __getitem__(self, item):
        if not isinstance(item, range):
            for key in self:
                if item in key:
                    return self[key]
            raise KeyError(item)
        else:
            return super().__getitem__(item)
