#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import uwsgi


def run_worker_uwsgi():

    from intranet.yandex_directory.src.yandex_directory import app
    from intranet.yandex_directory.src.yandex_directory.setup import setup_app
    from intranet.yandex_directory.src.yandex_directory.core.task_queue.utils import run_worker
    from intranet.yandex_directory.src.yandex_directory.core.task_queue.base import get_default_queue

    uwsgi.setprocname('worker.py')

    setup_app(app)

    parser = argparse.ArgumentParser(description='Start task queue worker.')
    parser.add_argument('--queue', help='имя очереди',  default=get_default_queue())
    parser.add_argument('--theta', help='коэффициент для расчёта',  default=0.1, type=float)
    parser.add_argument('--max-interval', help='миксимальный интервал поллинга (в секундах)',  default=30, type=float)
    parser.add_argument('--shard', help='номер шарда, по умолчанию будут выполняться таски во всех шардах',  default=None, type=int)
    args = parser.parse_args()

    run_worker(args.queue, shard=args.shard, theta=args.theta, max_interval=args.max_interval)


if __name__ == '__main__':
    run_worker_uwsgi()
