# -*- coding: utf-8 -*-

from flask import Flask
from flask_cors import CORS

from intranet.yandex_directory.src import settings

app_name = 'yandex_directory'
app = Flask(app_name)
app.config.from_object(settings)

CORS(app, origins=[r'^(https?://)?(.*\.)?yandex\.(ru|com|net|by|kz|ua|com\.tr)$'], supports_credentials=True)

app.TASK_MODULES = (
    'intranet.yandex_directory.src.yandex_directory.core.mailer.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.sms.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.utils.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.billing.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.events.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.mail_migration.account.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.mail_migration.mailbox.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.mail_migration.collector.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.mail_migration.transfer.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.mail_migration.migration.tasks',
    'intranet.yandex_directory.src.yandex_directory.core.registrar.tasks',
    'intranet.yandex_directory.src.yandex_directory.access_restore.tasks',
)

