# -*- coding: utf-8 -*-
from flask import (
    request,
)

from intranet.yandex_directory.src.yandex_directory.auth.decorators import (
    requires,
    permission_required,
)
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    build_list_response,
    json_response,
)
from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationAccessRestoreModel,
)
from intranet.yandex_directory.src.yandex_directory.core.permission.internal_permissions import (
    common_internal_permission,
)
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    ensure_integer,
)
from intranet.yandex_directory.src.yandex_directory.core.views.base import View



class AdminOrganizationAccessRestoreListView(View):

    @permission_required([common_internal_permission.organizations_restores_view])
    @requires(org_id=False, user=False)
    def get(self, meta_connection, _, org_id):
        """
        Отдает список запросов на восстановление доступа

        ---
        tags:
          - Админка
        parameters:
          - in: path
            name: org_id
            type: integer
            required: true
            description: id организации
          - in: query
            name: id
            type: integer
            description: id заявки
          - in: query
            name: state
            type: string
            description: статус заявки
        responses:
          200:
            description: Список заявок организации
        """
        org_id = ensure_integer(org_id, 'org_id')
        response = build_list_response(
            model=OrganizationAccessRestoreModel(meta_connection),
            model_fields=['*',],
            model_filters=self._get_filters(org_id),
            path=request.path,
            query_params=request.args.to_dict(),
            max_per_page=50,
        )
        return json_response(
            response['data'],
            headers=response['headers'],
        )

    def _get_filters(self, org_id):
        filters = {
            'org_id': org_id
        }

        def _build_list_filter(field_name):
            if request.args.get(field_name):
                filters[field_name] = request.args.get(field_name)

        _build_list_filter('id')
        _build_list_filter('state')
        return filters
