# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.auth.decorators import (
    requires,
    permission_required)
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    json_response,
)
from intranet.yandex_directory.src.yandex_directory.core.permission.internal_permissions import assessor_internal_pemissions
from intranet.yandex_directory.src.yandex_directory.core.views.base import View
from intranet.yandex_directory.src.yandex_directory.core.task_queue.base import (
    get_task_names_map,
)


class TaskNamesView(View):
    @requires(org_id=False, user=False)
    @permission_required([assessor_internal_pemissions.see_tasks])
    def get(self, meta_connection, main_connection):
        """Выдает список всех возможных имен асинхронных тасков.
        """
        result = list(get_task_names_map().keys())
        result.sort()
        return json_response(result)
