# coding: utf-8
from flask import g

from intranet.yandex_directory.src.yandex_directory.auth.scopes import check_scopes
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory.common.exceptions import (
    AuthorizationError,
)
from intranet.yandex_directory.src.yandex_directory.core.models.group import (
    GROUP_TYPE_GENERIC,
)


def raise_error_if_unable_to_use_group_type(group_type):
    """Эта вспомогательная функция используется во вью
    для проверки того, может ли сервис создавать или удалять
    группы определённого типа. Для этого у него должен
    быть специальный скоуп.
    """
    # без проверки прав на тип группы можно создавать только
    # группы типа generic
    if group_type != GROUP_TYPE_GENERIC:
        dynamic_scope_name = 'create_groups_of_type_{}'.format(group_type)
        required_scopes = [dynamic_scope_name]
        if not check_scopes(g.scopes, required_scopes):
            with log.fields(scopes=g.scopes,
                            required_scopes=required_scopes):
                log.warning('No required scope')

            raise AuthorizationError(
                'This operation requires one of scopes: {0}'.format(
                    ', '.join(required_scopes)
                )
            )

