# -*- coding: utf-8 -*-
import os
from intranet.yandex_directory.src.yandex_directory import app

# для кэширования данных из файла
# SERVICE_OAUTH_DATA_FILE
_oauth_service_data = {}

# в OAuth Яндекса скоупы имеют вид "<service-slug>:<scope>"
class scope:
    """
    Список доступных scopes для доступа к директории
    """
    read_users = 'directory:read_users'  # Чтение данных о сотрудниках
    write_users = 'directory:write_users'  # Управление пользователями
    read_departments = 'directory:read_departments'  # Чтение данных об отделах
    write_departments = 'directory:write_departments'  # Управление отделами
    read_groups = 'directory:read_groups'  # Чтение данных о командах
    write_groups = 'directory:write_groups'  # Управление командами
    read_resources = 'directory:read_resources'  # Чтение данных о ресурсах
    write_resources = 'directory:write_resources'  # Управление ресурсами
    read_webhooks = 'directory:read_webhooks'  # Чтение данных об подписках на события
    write_webhooks = 'directory:write_webhooks'  # Управление подписками на события
    read_domains = 'directory:read_domains'  # Чтение данных о доменах организации
    write_domains = 'directory:write_domains'  # Управление доменами организации
    read_projects = 'directory:read_projects'  # Чтение данных о проектах
    write_projects = 'directory:write_projects'  # Редактирование проектами
    read_roles = 'directory:read_roles'  # Чтение данных о ролях
    write_roles = 'directory:write_roles'  # Управление ролями
    read_actions = 'directory:read_actions'  # Чтение журнала действий
    read_events = 'directory:read_events'  # Чтение журнала событий
    read_organization = 'directory:read_organization'  # Чтение данных об организациях пользователя
    write_organization = 'directory:write_organization'  # Редактирование организации
    delete_organization = 'directory:delete_organization' # Удаление организации
    read_services = 'directory:read_services'  # Чтение данных о доступных сервисах - скрыт
    write_services = 'directory:write_services'  # Редактирование сервисов организации - скрыт
    read_service_licenses = 'directory:read_service_licenses'  # Чтение списка лицензий сервиса
    manage_service_licenses = 'directory:manage_service_licenses'  # Управление лицензиями сервиса
    read_tasks = 'directory:read_tasks'  # Чтение статуса задачи из очереди задач - скрыт
    manage_yamb_bots = 'directory:manage_yamb_bots'  # Управление ботами Ямб
    migrate_emails = 'directory:migrate_emails'  # Миграция ящиков

    ## Специальные скоупы, которых нет в OAuth

    # Сервис может представляться любым пользователем организации в которой подключён.
    work_on_behalf_of_any_user = 'work_on_behalf_of_any_user'
    # Сервис имеет доступ ко всем организациям без необходимости явного подключения.
    # На практике, это обозначает, что он может передавать любой X-Org-ID.
    work_with_any_organization = 'work_with_any_organization'

    # сервис может менять режим платности в организации
    can_change_subscription_plan = 'can_change_subscription_plan'

    # сервис может просматривать биллинговую информацию организации
    can_view_billing_info = 'can_view_billing_info'

    # сервис может формировать ссылку на оплату услуг
    can_pay = 'can_pay'

    # сервис может активировать промокоды
    activate_promocode = 'activate_promocode'

    # скоуп для интегриционных тестов отправки/получения писем
    integration_tests_send_emails = 'integration_tests_send_emails'

    use_invites = 'use_invites'

    # скоуп для внутренней админки
    internal_admin = 'internal_admin'

    # смена владельца организации
    change_owner = 'change_owner'

    # восстановление доступа
    access_restore = 'access_restore'

    # управление регистраторами из ПДД
    manage_registrar = 'manage_registrar'

    # управление доменныеми токенами
    manage_domain_token = 'manage_domain_token'

    # чтение ресурсов произвольного сервиса
    read_service_resources = 'read_service_resources'
    # изменение ресурсов произвольного сервиса
    change_service_resources = 'change_service_resources'
    # управление relation произвольного сервиса
    change_resource_relations = 'change_resource_relations'

    # для сервиса pdd_adapter
    pdd_proxy = 'pdd_proxy'

    # Права для работы с IDM
    connect_idm_application = 'connect_idm_application'

    # управление лимитами организации
    manage_limits = 'manage_limits'

    domenator = 'domenator'

    read_sso_settings = 'read_sso_settings'
    write_sso_settings = 'write_sso_settings'


class ScopeCheckMethod:
    OR = 'or'
    AND = 'and'


scope_descriptions = {
    scope.read_users: 'Чтение данных о сотрудниках',
    scope.write_users: 'Управление пользователями',
    scope.read_departments: 'Чтение данных об отделах',
    scope.write_departments: 'Управление отделами',
    scope.read_groups: 'Чтение данных о командах',
    scope.write_groups: 'Управление командами',
    scope.read_resources: 'Чтение данных о ресурсах',
    scope.write_resources: 'Управление ресурсами',
    scope.read_webhooks: 'Чтение данных об подписках на события',
    scope.write_webhooks: 'Управление подписками на события',
    scope.read_domains: 'Чтение данных о доменах организации',
    scope.write_domains: 'Управление доменами организации',
    scope.read_projects: 'Чтение данных о проектах',
    scope.write_projects: 'Редактирование проектами',
    scope.read_roles: 'Чтение данных о ролях',
    scope.write_roles: 'Управление ролями',
    scope.read_actions: 'Чтение журнала действий',
    scope.read_events: 'Чтение журнала событий',
    scope.read_organization: 'Чтение данных об организациях пользователя',
    scope.write_organization: 'Редактирование организации',
    scope.delete_organization: 'Удаление организации',
    scope.read_tasks: 'Чтение статуса задачи в очереди задач',  # скрыт
    scope.read_services: 'Чтение данных о доступных сервисах',  # скрыт
    scope.write_services: 'Редактирование сервисов организации',  # скрыт
    scope.read_service_licenses: 'Чтение списка лицензий сервиса',
    scope.manage_service_licenses: 'Управление лицензиями сервиса',
    scope.manage_yamb_bots: 'Управление ботами Ямб',
    scope.migrate_emails: 'Миграция ящиков',
    scope.change_owner: 'Смена владельца организации',
    scope.access_restore: 'Восстановление доступа к организации',
    scope.connect_idm_application: 'Работа с правами сервиса через IDM',
    scope.read_sso_settings: 'Чтение настроек SSO',
    scope.write_sso_settings: 'Сохранение настроек SSO',

    # Специальные скоупы
    scope.work_on_behalf_of_any_user: 'Работа от имени любого сотрудника',
    scope.work_with_any_organization: 'Работа с любой организацией без подключения',
    scope.integration_tests_send_emails: 'Отправка писем через внутреннюю ручку',
    scope.use_invites: 'Создание и использование Invite кодов',
    scope.can_change_subscription_plan: 'Изменение тарифного плана организации',
    scope.can_pay: 'Формирование ссылки на оплату услуг',
    scope.can_view_billing_info: 'Просмотр биллинговой информации организации',
    scope.activate_promocode: 'Активация промокодов',
    scope.internal_admin: 'Внутренний админ',
    scope.manage_registrar: 'Управление регистраторами из ПДД',
    scope.manage_domain_token: 'Управление доменными токенами',
    scope.manage_limits: 'Управление лимитами организации',

    scope.read_service_resources: 'Чтение ресурсов произвольного сервиса',
    scope.change_service_resources: 'Изменение ресурсов произвольного сервиса',
    scope.change_resource_relations: 'Управление relation произвольного сервиса',
    scope.pdd_proxy: 'Скоуп сервиса pdd_adapter'
}


def expand_scopes(scopes):
    """Если среди скоупов есть *, то он раскрывается во все скоупы которые
       возможны.
    """
    if '*' in scopes:
        return set(scope_descriptions)
    return set(scopes)


def check_scopes(service_scopes, required_scopes, method=ScopeCheckMethod.OR):
    """
    Проверяем наличие хотябы одного права у сервиса
    :param method: Метод проверки скоупров (И/ИЛИ)
    :param service_scopes: Права сервиса
    :type service_scopes: list[string]
    :param required_scopes: Необходимые права
    :type required_scopes: list[string]
    :rtype: bool: True, если один из необходимых скоупов есть
                  и False в противном случае.
    """
    # Так как в скоупах сервиса могут быть *,
    # то их надо раскрыть прежде чем сравнивать.
    service_scopes = expand_scopes(service_scopes)
    required_scopes = set(required_scopes)

    if method == ScopeCheckMethod.OR:
        return any(scope in service_scopes for scope in required_scopes)

    if method == ScopeCheckMethod.AND:
        return all(scope in service_scopes for scope in required_scopes)

    raise RuntimeError('Unknown check method %s' % method)


# TODO: надо будет сделать так, чтобы эта функция работала
#       и для tvm_client_id
def get_oauth_service_data(client_id):
    """
    Возваращем tuples client_id и secret для зарегистрированного сервиса
    :param client_id: client_id сервиса
    :type client_id: str
    :return: (client_id, secret)
    :type: tuple
    """
    if not _oauth_service_data:
        if 'SERVICE_OAUTH_DATA_FILE' in app.config:
            # файл с данными вида
            # <external_client_id> <internal_client_id> <secret>
            # external_client_id - из табличке services
            # специальные internal_client_id и secret для данного сервиса

            file_name = app.config['SERVICE_OAUTH_DATA_FILE']
            if os.path.isfile(file_name):
                with open(file_name) as f:
                    for line in f:
                        delimited = line.strip().split(' ')
                        if len(delimited) != 3:
                            continue
                        clnt_id, internal_client_id, secret = delimited
                        _oauth_service_data[clnt_id] = (internal_client_id, secret, )

    return _oauth_service_data.get(client_id, (None, None, ))
