# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory import app


def obfuscate_ticket(ticket):
    # Обфускация тикетов для логов.
    # Последнюю часть после ':' заменяем на '*'.
    try:
        obfuscated_ticket = ticket.rsplit(':', 1)[0] + ':' + \
                            '*' * len(ticket.rsplit(':', 1)[1])
    except IndexError:
        # Если не можем разделить тикет по ':', то скрываем весь тикет.
        obfuscated_ticket = '*' * len(ticket)
    return obfuscated_ticket


def hide_auth_from_headers(headers):
    # DIR-3657 "Запикиваем" тикеты, токены и куки при логировании.
    # Если есть такой заголовок, то в нём передан TVM тикет

    result = {}
    ticket_headers = [
        'ticket',
        'x-ya-service-ticket',
        'x-ya-user-ticket',
    ]

    for header, val in headers.items():
        if header.lower() in ticket_headers:
            result[header] = obfuscate_ticket(val)
        elif header.lower() == 'authorization':
            try:
                auth_name, token = val.split(' ', 1)
                result[header] = '{name} {token}'.format(
                    name=auth_name,
                    token=obfuscate_ticket(token)
                )
            except ValueError:
                result[header] = app.config['SECRET_PLACEHOLDER']
        elif header.lower() == 'cookie':
            result[header] = app.config['SECRET_PLACEHOLDER']
        else:
            result[header] = val

    return result
